/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.xforceplus.ultraman.transfer.client.IBocpClient;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.client.listener.IBocpServerMessageListener;
import com.xforceplus.ultraman.transfer.common.context.MetadataContextHolder;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import com.xforceplus.ultraman.transfer.storage.http.BocpOkHttpClient;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BocpHttpClient
extends BocpOkHttpClient
implements IBocpClient {
    private static final Logger log = LoggerFactory.getLogger(BocpHttpClient.class);
    public final String GET_METADATA_PATH = "%smetadatas/app-versions";
    private String bocpHost;
    private Boolean useSsl;
    private String apiPrefix;
    private OqsSdkProperties properties;
    private BocpClientSetting bocpClientSetting;
    private final OkHttpClient client;
    private List<IBocpServerMessageListener> listeners;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean initIsTriggered = false;
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public BocpHttpClient(boolean useSSl, BocpClientSetting bocpClientSetting, OqsSdkProperties oqsSdkProperties, List<IBocpServerMessageListener> listeners) {
        this.useSsl = useSSl;
        this.client = this.buildClient(this.useSsl, Collections.emptyList());
        this.properties = oqsSdkProperties;
        this.bocpClientSetting = bocpClientSetting;
        this.listeners = listeners;
    }

    public BocpHttpClient(String bocpHost, Boolean useSsl, String apiPrefix, OqsSdkProperties oqsSdkProperties, BocpClientSetting bocpClientSetting, MetadataHeadInterceptor metadataHeadInterceptor, List<IBocpServerMessageListener> listeners) {
        this.bocpClientSetting = bocpClientSetting;
        this.bocpHost = bocpHost;
        this.useSsl = useSsl;
        this.apiPrefix = apiPrefix;
        this.client = this.buildClient(useSsl, Arrays.asList(metadataHeadInterceptor));
        this.listeners = listeners;
        this.properties = oqsSdkProperties;
        this.init();
    }

    protected void init() {
        Long envLong;
        Long appIdLong;
        block6: {
            String appId = this.properties.getAuth().getAppId();
            String env = this.properties.getAuth().getEnv();
            RetryConfig config = RetryConfig.custom().maxAttempts(this.bocpClientSetting.getBocp().getFailureThreshold()).waitDuration(Duration.ofMillis(100L)).build();
            Retry requestRetry = Retry.of((String)"httpRequest", (RetryConfig)config);
            appIdLong = Long.parseLong(appId);
            envLong = Long.parseLong(env);
            try {
                requestRetry.executeRunnable(() -> this.requestLastMetadata(appIdLong, envLong));
            }
            catch (Throwable throwable) {
                if (!this.bocpClientSetting.getBocp().isSupportOffline() || this.initIsTriggered) break block6;
                TransferMessage transferMessage = new TransferMessage();
                transferMessage.setAppId(Long.valueOf(Long.parseLong(this.properties.getAuth().getAppId())));
                transferMessage.setMessageType(MessageType.CLIENT_CONNECT);
                transferMessage.setHandleSuccess(true);
                Optional.ofNullable(this.listeners).orElseGet(Collections::emptyList).forEach(listener -> {
                    try {
                        this.initIsTriggered = true;
                        listener.onTransferMessage(transferMessage).thenAccept(x -> this.latch.countDown());
                    }
                    catch (Throwable e) {
                        log.error("execute message task failed!", e);
                    }
                });
            }
        }
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.requestLastMetadata(appIdLong, envLong), 3L, 1L, TimeUnit.MINUTES);
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void requestLastMetadata(Long appId, Long envId) {
        Request request = this.buildRequest(appId, envId);
        try (Response resp = this.client.newCall(request).execute();){
            String body;
            JsonNode jsonNode;
            JsonNode transferBody;
            if (!resp.isSuccessful()) {
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5143\u6570\u636e\u63a5\u53e3\u5931\u8d25, msg = " + resp.message());
            }
            if (resp.body() != null && (transferBody = (jsonNode = JsonUtils.readTree((String)(body = resp.body().string()))).get("data")) != null) {
                String text = transferBody.toString();
                TransferMessage transferMessages = (TransferMessage)JsonUtils.json2Object((String)text, TransferMessage.class);
                String versionStr = transferMessages.getVersion();
                String version = MetadataContextHolder.currentVersion();
                transferMessages.setMessageType(MessageType.CLIENT_CONNECT);
                transferMessages.setHandleSuccess(true);
                if (!versionStr.equalsIgnoreCase(version)) {
                    Optional.ofNullable(this.listeners).orElseGet(Collections::emptyList).forEach(listener -> {
                        try {
                            listener.onTransferMessage(transferMessages).thenAccept(x -> this.latch.countDown());
                        }
                        catch (Throwable e) {
                            log.error("execute message task failed!", e);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Request buildRequest(Long appId, Long envId) {
        String realApiPrefix = StringUtils.isBlank((CharSequence)this.apiPrefix) ? "" : this.apiPrefix + "/";
        String realApiPath = String.format("%smetadatas/app-versions", realApiPrefix, envId);
        String url = MessageUtils.getUrl((String)this.bocpHost, (boolean)this.useSsl);
        HttpUrl hostUrl = HttpUrl.get((String)url);
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(MessageUtils.getSchema((boolean)this.useSsl)).host(hostUrl.host()).port(hostUrl.port()).addPathSegments(realApiPath).addQueryParameter("appId", appId.toString()).addQueryParameter("envId", envId.toString()).build();
        return new Request.Builder().url(httpUrl).build();
    }

    @Override
    public void sendMessage(String message) {
        log.warn("SendMessage not supported");
    }
}

