/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.client.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.client.BocpClient;
import com.xforceplus.ultraman.transfer.client.config.OqsSdkProperties;
import com.xforceplus.ultraman.transfer.common.context.MetadataContextHolder;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.domain.entity.DeployDetail;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/bocpclient"})
public class BocpClientController {
    private static final Logger log = LoggerFactory.getLogger(BocpClientController.class);
    private OqsSdkProperties oqsSdkProperties;
    private BocpClient bocpClient;

    public BocpClientController(OqsSdkProperties oqsSdkProperties, BocpClient bocpClient) {
        this.oqsSdkProperties = oqsSdkProperties;
        this.bocpClient = bocpClient;
    }

    @PostMapping(value={"/send"})
    @ResponseBody
    public void sendReplayMessage(@RequestBody TransferMessage replyMessage) {
        this.bocpClient.sendMessage(JsonUtils.object2Json((Object)replyMessage));
    }

    @GetMapping(value={"/pull"})
    @ResponseBody
    public void pull() {
        TransferMessage message = new TransferMessage();
        message.setAppId(Long.valueOf(this.oqsSdkProperties.getAuth().getAppId()));
        message.setEnv(this.oqsSdkProperties.getAuth().getEnv());
        message.setMessageType(MessageType.CLIENT_PULL);
        message.setForceUpdate(true);
        this.bocpClient.sendMessage(JsonUtils.object2Json((Object)message));
    }

    @GetMapping(value={"/current"})
    @ResponseBody
    public ResponseEntity current() {
        return ResponseEntity.ok((Object)this.buildCurrentInfo());
    }

    @GetMapping(value={"/current/details"})
    @ResponseBody
    public ResponseEntity currentDetails(@RequestParam(required=false) String[] types) {
        CurrentInfo currentInfo = this.buildCurrentInfo();
        currentInfo.setMetadataMap(this.buildMetadataMap(types));
        return ResponseEntity.ok((Object)currentInfo);
    }

    @GetMapping(value={"/dependency"})
    @ResponseBody
    public ResponseEntity dependency() throws IOException {
        List<Map> dependencyVersions = this.getDependencyVersions();
        return ResponseEntity.ok(dependencyVersions);
    }

    private List<Map> getDependencyVersions() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
        ArrayList result = Lists.newArrayList();
        while (resources.hasMoreElements()) {
            try {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                Attributes attributes = manifest.getMainAttributes();
                String implementationTitle = attributes.getValue("Implementation-Title");
                String implementationVersion = attributes.getValue("Implementation-Version");
                if (implementationTitle == null || implementationVersion == null) continue;
                HashMap item = Maps.newHashMap();
                item.put("dependency", implementationTitle);
                item.put("version", implementationVersion);
                result.add(item);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4f9d\u8d56\u7248\u672c\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        return result;
    }

    private CurrentInfo buildCurrentInfo() {
        CurrentInfo currentInfo = new CurrentInfo();
        currentInfo.setEnv(this.oqsSdkProperties.getAuth().getEnv());
        currentInfo.setVersion(MetadataContextHolder.currentVersion());
        if ("99".equals(this.oqsSdkProperties.getAuth().getEnv())) {
            String version = MetadataContextHolder.currentVersion();
            String[] split = version.split("\\.");
            String timestamp = split[1];
            String format = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(timestamp)), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            currentInfo.setVersion(split[0] + "." + format);
        }
        currentInfo.setAppCode(MetadataContextHolder.appCode());
        currentInfo.setAppCodeForDB(MetadataContextHolder.appCodeForDB());
        currentInfo.setAppId(MetadataContextHolder.appId());
        currentInfo.setDeployDetail(MetadataContextHolder.getDeployDetail());
        return currentInfo;
    }

    private Map<SchemaMetadataType, Object> buildMetadataMap(String[] types) {
        HashMap map = Maps.newHashMap();
        if (null == types || types.length == 0) {
            types = new String[]{SchemaMetadataType.DICT.code(), SchemaMetadataType.ENTITY.code(), SchemaMetadataType.SDK_SETTING.code(), SchemaMetadataType.ACTION.code(), SchemaMetadataType.APP_EVENT.code()};
        }
        Arrays.stream(types).forEach(type -> {
            SchemaMetadataType schemaMetadataType = SchemaMetadataType.fromCode((String)type);
            if (SchemaMetadataType.DICT.equals((Object)schemaMetadataType)) {
                map.put(SchemaMetadataType.DICT, MetadataContextHolder.getDictMetadata());
            } else if (SchemaMetadataType.ENTITY.equals((Object)schemaMetadataType)) {
                map.put(SchemaMetadataType.ENTITY, MetadataContextHolder.getEntityMetadata());
            } else if (SchemaMetadataType.SDK_SETTING.equals((Object)schemaMetadataType)) {
                map.put(SchemaMetadataType.SDK_SETTING, MetadataContextHolder.getSdkSettingMetadata());
            } else if (SchemaMetadataType.ACTION.equals((Object)schemaMetadataType)) {
                map.put(SchemaMetadataType.ACTION, MetadataContextHolder.getActionMetadata());
            } else if (SchemaMetadataType.APP_EVENT.equals((Object)schemaMetadataType)) {
                map.put(SchemaMetadataType.APP_EVENT, MetadataContextHolder.getAppEventMetadata());
            }
        });
        return map;
    }

    public static class CurrentInfo {
        private Long appId = null;
        private String env = null;
        private String appCode = null;
        private String appCodeForDB = null;
        private String version = "";
        private DeployDetail deployDetail = null;
        private Map<SchemaMetadataType, Object> metadataMap = Maps.newConcurrentMap();

        public Long getAppId() {
            return this.appId;
        }

        public String getEnv() {
            return this.env;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public String getAppCodeForDB() {
            return this.appCodeForDB;
        }

        public String getVersion() {
            return this.version;
        }

        public DeployDetail getDeployDetail() {
            return this.deployDetail;
        }

        public Map<SchemaMetadataType, Object> getMetadataMap() {
            return this.metadataMap;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public void setEnv(String env) {
            this.env = env;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public void setAppCodeForDB(String appCodeForDB) {
            this.appCodeForDB = appCodeForDB;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setDeployDetail(DeployDetail deployDetail) {
            this.deployDetail = deployDetail;
        }

        public void setMetadataMap(Map<SchemaMetadataType, Object> metadataMap) {
            this.metadataMap = metadataMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentInfo)) {
                return false;
            }
            CurrentInfo other = (CurrentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$appId = this.getAppId();
            Long other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
                return false;
            }
            String this$env = this.getEnv();
            String other$env = other.getEnv();
            if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
                return false;
            }
            String this$appCode = this.getAppCode();
            String other$appCode = other.getAppCode();
            if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
                return false;
            }
            String this$appCodeForDB = this.getAppCodeForDB();
            String other$appCodeForDB = other.getAppCodeForDB();
            if (this$appCodeForDB == null ? other$appCodeForDB != null : !this$appCodeForDB.equals(other$appCodeForDB)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            DeployDetail this$deployDetail = this.getDeployDetail();
            DeployDetail other$deployDetail = other.getDeployDetail();
            if (this$deployDetail == null ? other$deployDetail != null : !this$deployDetail.equals(other$deployDetail)) {
                return false;
            }
            Map<SchemaMetadataType, Object> this$metadataMap = this.getMetadataMap();
            Map<SchemaMetadataType, Object> other$metadataMap = other.getMetadataMap();
            return !(this$metadataMap == null ? other$metadataMap != null : !((Object)this$metadataMap).equals(other$metadataMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CurrentInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
            String $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : $env.hashCode());
            String $appCode = this.getAppCode();
            result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
            String $appCodeForDB = this.getAppCodeForDB();
            result = result * 59 + ($appCodeForDB == null ? 43 : $appCodeForDB.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            DeployDetail $deployDetail = this.getDeployDetail();
            result = result * 59 + ($deployDetail == null ? 43 : $deployDetail.hashCode());
            Map<SchemaMetadataType, Object> $metadataMap = this.getMetadataMap();
            result = result * 59 + ($metadataMap == null ? 43 : ((Object)$metadataMap).hashCode());
            return result;
        }

        public String toString() {
            return "BocpClientController.CurrentInfo(appId=" + this.getAppId() + ", env=" + this.getEnv() + ", appCode=" + this.getAppCode() + ", appCodeForDB=" + this.getAppCodeForDB() + ", version=" + this.getVersion() + ", deployDetail=" + this.getDeployDetail() + ", metadataMap=" + this.getMetadataMap() + ")";
        }
    }
}

