/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAction;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApiAuthTemplate;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppEvent;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaTenant;
import com.xforceplus.ultraman.transfer.domain.entity.DeployDetail;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MetadataContextHolder {
    private static final Map<SchemaMetadataType, Object> metadataMap = Maps.newConcurrentMap();
    private static volatile Long appId = null;
    private static volatile String appCode = null;
    private static volatile String appCodeForDB = null;
    private static volatile String version = "";
    private static volatile MessageType messageType = null;
    private static volatile DeployDetail deployDetail;
    private static volatile Long teamId;
    private static volatile String teamCode;
    private static volatile boolean firstDeploy;

    public static ImmutableList<SchemaBo> getEntityMetadata() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.ENTITY)));
    }

    public static ImmutableList<SchemaDict> getDictMetadata() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.DICT)));
    }

    public static ImmutableList<SchemaAction> getActionMetadata() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.ACTION)));
    }

    public static ImmutableList<SchemaAppEvent> getAppEventMetadata() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.APP_EVENT)));
    }

    public static ImmutableList<SchemaSdkSetting> getSdkSettingMetadata() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.SDK_SETTING)));
    }

    public static List<SchemaSdkSetting> getAppI18nLocaleMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.APP_I18N_LOCALE);
    }

    public static synchronized void init(String appIdStr, TransferMessage transferMessage, SchemaApp schemaApp) {
        version = transferMessage.getVersion();
        messageType = transferMessage.getMessageType();
        deployDetail = transferMessage.getDeployDetail();
        firstDeploy = transferMessage.isFirstDeploy();
        if (!StringUtils.isBlank((CharSequence)appIdStr)) {
            appId = Long.valueOf(appIdStr);
        }
        if (!StringUtils.isBlank((CharSequence)transferMessage.getAppCode())) {
            appCode = transferMessage.getAppCode();
        }
        if (!StringUtils.isBlank((CharSequence)transferMessage.getAppCodeForDB())) {
            appCodeForDB = transferMessage.getAppCodeForDB();
        }
        Optional.ofNullable(schemaApp.getBos()).ifPresent(l -> metadataMap.put(SchemaMetadataType.ENTITY, l));
        Optional.ofNullable(schemaApp.getDicts()).ifPresent(l -> metadataMap.put(SchemaMetadataType.DICT, l));
        Optional.ofNullable(schemaApp.getActions()).ifPresent(l -> metadataMap.put(SchemaMetadataType.ACTION, l));
        Optional.ofNullable(schemaApp.getAppEvents()).ifPresent(l -> metadataMap.put(SchemaMetadataType.APP_EVENT, l));
        Optional.ofNullable(schemaApp.getSdkSettings()).ifPresent(l -> metadataMap.put(SchemaMetadataType.SDK_SETTING, l));
        Optional.ofNullable(schemaApp.getAppI18nLocales()).ifPresent(l -> metadataMap.put(SchemaMetadataType.APP_I18N_LOCALE, l));
        if (null != transferMessage.getTeamId()) {
            teamId = transferMessage.getTeamId();
        }
        if (!StringUtils.isBlank((CharSequence)transferMessage.getTeamCode())) {
            teamCode = transferMessage.getTeamCode();
        }
        SchemaTenant tenant = new SchemaTenant();
        tenant.setId("0");
        tenant.setTenantId("0");
        tenant.setTenantCode(teamCode);
        tenant.setTenantName("\u9ed8\u8ba4\u79df\u6237");
        Optional<List> schemaAppTenants = Optional.ofNullable(schemaApp.getTenants());
        if (schemaAppTenants.isPresent()) {
            schemaAppTenants.get().add(tenant);
            metadataMap.put(SchemaMetadataType.TENANT, schemaAppTenants.get());
        } else {
            metadataMap.put(SchemaMetadataType.TENANT, Collections.singletonList(tenant));
        }
        Optional.ofNullable(schemaApp.getAuthTemplates()).ifPresent(authTemplates -> metadataMap.put(SchemaMetadataType.API_AUTH_TEMPLATE, authTemplates));
    }

    public static synchronized void update(String appIdStr, TransferMessage transferMessage, SchemaApp schemaApp) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)transferMessage.getVersion()) ? 1 : 0) != 0, (Object)"\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MetadataContextHolder.init(appIdStr, transferMessage, schemaApp);
    }

    public static synchronized void updateBos(List<SchemaBo> bos) {
        Optional.ofNullable(bos).ifPresent(o -> metadataMap.put(SchemaMetadataType.ENTITY, o));
    }

    public static synchronized void updateDicts(List<SchemaDict> dicts) {
        Optional.ofNullable(dicts).ifPresent(o -> metadataMap.put(SchemaMetadataType.DICT, o));
    }

    public static String currentVersion() {
        return version;
    }

    public static Long appId() {
        return appId;
    }

    public static String appCode() {
        return appCode;
    }

    public static String appCodeForDB() {
        return appCodeForDB;
    }

    public static MessageType getMessageType() {
        return messageType;
    }

    public static DeployDetail getDeployDetail() {
        return deployDetail;
    }

    public static Long teamId() {
        return teamId;
    }

    public static String teamCode() {
        return teamCode;
    }

    public static ImmutableList<SchemaTenant> getTeamTenants() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.TENANT)));
    }

    public static ImmutableList<SchemaApiAuthTemplate> getAuthTemplates() {
        return ImmutableList.copyOf((Collection)((List)metadataMap.get(SchemaMetadataType.API_AUTH_TEMPLATE)));
    }

    public static boolean isFirstDeploy() {
        return firstDeploy;
    }

    static {
        teamId = null;
        teamCode = null;
        firstDeploy = false;
    }
}

