/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.context;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.global.common.enums.AppI18nResourceType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppI18nLocale;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppI18nResource;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MetadataI18nContextHolder {
    public static final String DEFAULT_KEY = "_default";
    private static final ConcurrentHashMap<String, List<SchemaAppI18nLocale>> rawI18nLocaleMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<SchemaAppI18nResource>> rawI18nResourceMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ImmutableList<SchemaAppI18nLocale>> i18nLocaleMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, String>>>> backendI18nResourceMap = new ConcurrentHashMap();

    public static ImmutableList<SchemaAppI18nLocale> i18nLocales() {
        return i18nLocaleMap.get(DEFAULT_KEY);
    }

    public static ImmutableList<SchemaAppI18nLocale> i18nLocales(String tenantCode) {
        return ImmutableList.copyOf((Collection)((Collection)i18nLocaleMap.get(MetadataI18nContextHolder.getTenantCodeOrDefaultKey(tenantCode))));
    }

    public static synchronized void init(Map<String, List<SchemaAppI18nLocale>> appI18nLocaleMap, Map<String, List<SchemaAppI18nResource>> appI18nResourceMap) {
        rawI18nLocaleMap.clear();
        rawI18nResourceMap.clear();
        Optional.ofNullable(appI18nLocaleMap).ifPresent(m -> {
            rawI18nLocaleMap.putAll(appI18nLocaleMap);
            m.forEach((key, value) -> i18nLocaleMap.put((String)key, (ImmutableList<SchemaAppI18nLocale>)ImmutableList.copyOf((Collection)value.stream().map(o -> MetadataI18nContextHolder.buildI18nLocale(o.getLanguageCode(), o.getRegionCode())).distinct().map(locale -> {
                String[] s = locale.split("-");
                SchemaAppI18nLocale appI18nLocale = new SchemaAppI18nLocale();
                appI18nLocale.setLanguageCode(s[0]);
                appI18nLocale.setRegionCode(s[1]);
                return appI18nLocale;
            }).collect(Collectors.toList()))));
        });
        Optional.ofNullable(appI18nResourceMap).ifPresent(m -> {
            rawI18nResourceMap.putAll(appI18nResourceMap);
            m.forEach((key, value) -> backendI18nResourceMap.put((String)key, MetadataI18nContextHolder.buildBackendI18nResourceMap(value)));
        });
    }

    public static synchronized void update(Map<String, List<SchemaAppI18nLocale>> appI18nLocaleMap, Map<String, List<SchemaAppI18nResource>> appI18nResourceMap) {
        MetadataI18nContextHolder.init(appI18nLocaleMap, appI18nResourceMap);
    }

    public static ImmutableMap<String, ImmutableMap<String, String>> getI18nResourceMap(String resourceCode) {
        return MetadataI18nContextHolder.getTenantI18nResourceMap(resourceCode, DEFAULT_KEY);
    }

    public static ImmutableMap<String, ImmutableMap<String, String>> getTenantI18nResourceMap(String resourceCode, String tenantCode) {
        String key = MetadataI18nContextHolder.getTenantCodeOrDefaultKey(tenantCode);
        return (ImmutableMap)Optional.ofNullable(Optional.ofNullable(backendI18nResourceMap.get(key)).orElse(backendI18nResourceMap.get(DEFAULT_KEY)).get((Object)resourceCode)).orElse(ImmutableMap.of());
    }

    public static ImmutableMap<String, String> getLocaleI18nResourceMap(String resourceCode, String i18nLocale) {
        return MetadataI18nContextHolder.getTenantI18nResourceMap(resourceCode, i18nLocale, DEFAULT_KEY);
    }

    public static ImmutableMap<String, String> getTenantI18nResourceMap(String resourceCode, String i18nLocale, String tenantCode) {
        String key = MetadataI18nContextHolder.getTenantCodeOrDefaultKey(tenantCode);
        return Optional.ofNullable(MetadataI18nContextHolder.getTenantI18nResourceMap(resourceCode, key)).map(m -> (ImmutableMap)m.get((Object)i18nLocale)).orElse(ImmutableMap.of());
    }

    public static ImmutableMap<String, String> getLocaleI18nResourceMap(String resourceKey, String languageCode, String regionCode) {
        return MetadataI18nContextHolder.getTenantLocaleI18nResourceMap(resourceKey, languageCode, regionCode, DEFAULT_KEY);
    }

    public static ImmutableMap<String, String> getTenantLocaleI18nResourceMap(String resourceKey, String languageCode, String regionCode, String tenantCode) {
        String key = MetadataI18nContextHolder.getTenantCodeOrDefaultKey(tenantCode);
        return Optional.ofNullable(MetadataI18nContextHolder.getTenantI18nResourceMap(resourceKey, key)).map(m -> (ImmutableMap)m.get((Object)MetadataI18nContextHolder.buildI18nLocale(languageCode, regionCode))).orElse(ImmutableMap.of());
    }

    private static List<I18nResource> parseI18nResource(String i18nResourceStr) {
        try {
            return Optional.ofNullable(JsonUtils.json2ObjectList(i18nResourceStr, I18nResource.class)).map(l -> l.stream().filter(Objects::nonNull).collect(Collectors.toList())).orElse(Lists.newArrayList());
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static String buildI18nLocale(String languageCode, String regionCode) {
        return String.format("%s-%s", languageCode, regionCode);
    }

    private static ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, String>>> buildBackendI18nResourceMap(List<SchemaAppI18nResource> appI18nResources) {
        HashMap result = Maps.newHashMap();
        Optional.ofNullable(appI18nResources).ifPresent(l -> {
            List backendI18nResourceTypeNames = AppI18nResourceType.SDK_TYPES_PLUS_CUSTOM.stream().map(Enum::name).collect(Collectors.toList());
            l.stream().filter(o -> backendI18nResourceTypeNames.contains(o.getType())).forEach(o -> {
                String key;
                List<I18nResource> i18nResources = MetadataI18nContextHolder.parseI18nResource(o.getResourceContent());
                List<String> i18nLocales = i18nResources.stream().map(o1 -> MetadataI18nContextHolder.buildI18nLocale(o1.getLanguageCode(), o1.getRegionCode())).distinct().collect(Collectors.toList());
                String string = key = AppI18nResourceType.CUSTOM.name().equals(o.getType()) ? o.getResourceCode() : o.getType();
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    result.put(key, MetadataI18nContextHolder.buildI18nResourceMap(i18nLocales, i18nResources));
                }
            });
        });
        return ImmutableMap.copyOf((Map)result);
    }

    private static ImmutableMap<String, ImmutableMap<String, String>> buildI18nResourceMap(List<String> i18nLocales, List<I18nResource> i18nResources) {
        HashMap result = Maps.newHashMap();
        i18nLocales.forEach(i18nLocale -> {
            Map<String, String> i18nResourceMap = i18nResources.stream().filter(o -> i18nLocale.equals(MetadataI18nContextHolder.buildI18nLocale(o.getLanguageCode(), o.getRegionCode()))).collect(Collectors.toMap(I18nResource::getResourceKey, o -> Optional.ofNullable(o.getResourceValue()).orElse("")));
            result.put(i18nLocale, ImmutableMap.copyOf(i18nResourceMap));
        });
        return ImmutableMap.copyOf((Map)result);
    }

    private static String getTenantCodeOrDefaultKey(String tenantCode) {
        return StringUtils.isBlank((CharSequence)tenantCode) ? DEFAULT_KEY : tenantCode;
    }

    public static ConcurrentHashMap<String, List<SchemaAppI18nLocale>> getRawI18nLocaleMap() {
        return rawI18nLocaleMap;
    }

    public static ConcurrentHashMap<String, List<SchemaAppI18nResource>> getRawI18nResourceMap() {
        return rawI18nResourceMap;
    }

    public static class I18nResource {
        private String jsonPath;
        private String resourceKey;
        private String resourceValue;
        private String resourceDesc;
        private String resourceIcon;
        private String regionCode;
        private String languageCode;

        public String getJsonPath() {
            return this.jsonPath;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public String getResourceValue() {
            return this.resourceValue;
        }

        public String getResourceDesc() {
            return this.resourceDesc;
        }

        public String getResourceIcon() {
            return this.resourceIcon;
        }

        public String getRegionCode() {
            return this.regionCode;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public void setResourceValue(String resourceValue) {
            this.resourceValue = resourceValue;
        }

        public void setResourceDesc(String resourceDesc) {
            this.resourceDesc = resourceDesc;
        }

        public void setResourceIcon(String resourceIcon) {
            this.resourceIcon = resourceIcon;
        }

        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof I18nResource)) {
                return false;
            }
            I18nResource other = (I18nResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonPath = this.getJsonPath();
            String other$jsonPath = other.getJsonPath();
            if (this$jsonPath == null ? other$jsonPath != null : !this$jsonPath.equals(other$jsonPath)) {
                return false;
            }
            String this$resourceKey = this.getResourceKey();
            String other$resourceKey = other.getResourceKey();
            if (this$resourceKey == null ? other$resourceKey != null : !this$resourceKey.equals(other$resourceKey)) {
                return false;
            }
            String this$resourceValue = this.getResourceValue();
            String other$resourceValue = other.getResourceValue();
            if (this$resourceValue == null ? other$resourceValue != null : !this$resourceValue.equals(other$resourceValue)) {
                return false;
            }
            String this$resourceDesc = this.getResourceDesc();
            String other$resourceDesc = other.getResourceDesc();
            if (this$resourceDesc == null ? other$resourceDesc != null : !this$resourceDesc.equals(other$resourceDesc)) {
                return false;
            }
            String this$resourceIcon = this.getResourceIcon();
            String other$resourceIcon = other.getResourceIcon();
            if (this$resourceIcon == null ? other$resourceIcon != null : !this$resourceIcon.equals(other$resourceIcon)) {
                return false;
            }
            String this$regionCode = this.getRegionCode();
            String other$regionCode = other.getRegionCode();
            if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
                return false;
            }
            String this$languageCode = this.getLanguageCode();
            String other$languageCode = other.getLanguageCode();
            return !(this$languageCode == null ? other$languageCode != null : !this$languageCode.equals(other$languageCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof I18nResource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonPath = this.getJsonPath();
            result = result * 59 + ($jsonPath == null ? 43 : $jsonPath.hashCode());
            String $resourceKey = this.getResourceKey();
            result = result * 59 + ($resourceKey == null ? 43 : $resourceKey.hashCode());
            String $resourceValue = this.getResourceValue();
            result = result * 59 + ($resourceValue == null ? 43 : $resourceValue.hashCode());
            String $resourceDesc = this.getResourceDesc();
            result = result * 59 + ($resourceDesc == null ? 43 : $resourceDesc.hashCode());
            String $resourceIcon = this.getResourceIcon();
            result = result * 59 + ($resourceIcon == null ? 43 : $resourceIcon.hashCode());
            String $regionCode = this.getRegionCode();
            result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
            String $languageCode = this.getLanguageCode();
            result = result * 59 + ($languageCode == null ? 43 : $languageCode.hashCode());
            return result;
        }

        public String toString() {
            return "MetadataI18nContextHolder.I18nResource(jsonPath=" + this.getJsonPath() + ", resourceKey=" + this.getResourceKey() + ", resourceValue=" + this.getResourceValue() + ", resourceDesc=" + this.getResourceDesc() + ", resourceIcon=" + this.getResourceIcon() + ", regionCode=" + this.getRegionCode() + ", languageCode=" + this.getLanguageCode() + ")";
        }
    }
}

