/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.USE_LONG_FOR_INTS, true).configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, false).configure(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN, true);

    public static <T> String object2Json(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("obj to json failed, error : " + e.getMessage());
        }
    }

    public static <T> T json2Object(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json) || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? json : objectMapper.readValue(json, clazz));
        }
        catch (Exception e) {
            throw new RuntimeException("json To obj is failed, error : " + e.getMessage());
        }
    }

    public static JsonNode readTree(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (Exception e) {
            throw new RuntimeException("json To tree is failed, error : " + e.getMessage());
        }
    }

    public static <T> List<T> json2ObjectList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json) || clazz == null) {
            return null;
        }
        try {
            return (List)objectMapper.readValue(json, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
        }
        catch (Exception e) {
            throw new RuntimeException("json To obj is failed, error : " + e.getMessage());
        }
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule((Module)javaTimeModule);
    }
}

