/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.util;

import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import java.util.UUID;

public class MessageUtils {
    public static String getRealWsUrl(String host, boolean useSsl) {
        return String.format("%s://%s/websocket", useSsl ? "wss" : "ws", host);
    }

    public static String getUrl(String host, boolean useSsl) {
        return String.format("%s://%s", useSsl ? "https" : "http", host);
    }

    public static String getUrl(String host, boolean useSsl, String apiUrl) {
        return String.format("%s://%s%s", useSsl ? "https" : "http", host, apiUrl);
    }

    public static String getSchema(boolean useSsl) {
        return useSsl ? "https" : "http";
    }

    public static TransferMessage buildReplyMessage(TransferMessage message, boolean success, String desc) {
        TransferMessage transferReplyMessage = new TransferMessage();
        transferReplyMessage.setAppId(message.getAppId());
        transferReplyMessage.setEnv(message.getEnv());
        transferReplyMessage.setVersion(message.getVersion());
        transferReplyMessage.setMessageType(message.getMessageType());
        transferReplyMessage.setReplyMessage(true);
        transferReplyMessage.setOrigId(message.getId());
        transferReplyMessage.setHandleSuccess(success);
        transferReplyMessage.setId(UUID.randomUUID().toString());
        transferReplyMessage.setHandleMessage(desc);
        return transferReplyMessage;
    }
}

