package com.xforceplus.ultraman.transfer.common.event.publisher;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.MulticastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;

import java.util.function.Consumer;

public class RxEventStream<T> implements EventStream<T> {

    private MulticastProcessor<T> dws = MulticastProcessor.create();

    private Flowable<T> flowable;

    public RxEventStream() {
        flowable = dws.onBackpressureBuffer(10000);
        dws.start();

    }

    @Override
    public void offer(T t) {
        dws.onNext(t);
    }

    @Override
    public void subscribe(Consumer<? super T> consumer) {
        flowable.observeOn(Schedulers.io())
                .subscribe(consumer::accept);
    }
}
