package com.xforceplus.ultraman.transfer.common.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.*;
import com.xforceplus.ultraman.transfer.domain.entity.DeployDetail;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import org.apache.commons.lang3.StringUtils;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/11/10 17:33
 * @since 1.8
 */
public class MetadataContextHolder {

    private static final Map<SchemaMetadataType, Object> metadataMap = Maps.newConcurrentMap();

    private static volatile Long appId = null;

    private static volatile String appCode = null;

    private static volatile String appCodeForDB = null;

    private static volatile String version = StringUtils.EMPTY;

    private static volatile MessageType messageType = null;

    private static volatile DeployDetail deployDetail;

    public static List<SchemaBo> getEntityMetadata() {
        return (List<SchemaBo>) metadataMap.get(SchemaMetadataType.ENTITY);
    }

    public static List<SchemaDict> getDictMetadata() {
        return (List<SchemaDict>) metadataMap.get(SchemaMetadataType.DICT);
    }

    public static List<SchemaAction> getActionMetadata() {
        return (List<SchemaAction>) metadataMap.get(SchemaMetadataType.ACTION);
    }

    public static List<SchemaAppEvent> getAppEventMetadata() {
        return (List<SchemaAppEvent>) metadataMap.get(SchemaMetadataType.APP_EVENT);
    }

    public static List<SchemaSdkSetting> getSdkSettingMetadata() {
        return (List<SchemaSdkSetting>) metadataMap.get(SchemaMetadataType.SDK_SETTING);
    }

    public static synchronized void update(String appIdStr, TransferMessage transferMessage, SchemaApp schemaApp) {
        Preconditions.checkArgument(!StringUtils.isBlank(transferMessage.getVersion()), "版本信息不能为空！");
        version = transferMessage.getVersion();
        messageType = transferMessage.getMessageType();
        deployDetail = transferMessage.getDeployDetail();

        if(!StringUtils.isBlank(appIdStr)) {
            appId = Long.valueOf(appIdStr);
        }
        if(!StringUtils.isBlank(transferMessage.getAppCode())) {
            appCode = transferMessage.getAppCode();
        }
        if(!StringUtils.isBlank(transferMessage.getAppCodeForDB())) {
            appCodeForDB = transferMessage.getAppCodeForDB();
        }

        Optional.ofNullable(schemaApp.getBos()).ifPresent(bos -> metadataMap.put(SchemaMetadataType.ENTITY, bos));
        Optional.ofNullable(schemaApp.getDicts()).ifPresent(dicts -> metadataMap.put(SchemaMetadataType.DICT, dicts));
        Optional.ofNullable(schemaApp.getActions()).ifPresent(actions -> metadataMap.put(SchemaMetadataType.ACTION, actions));
        Optional.ofNullable(schemaApp.getAppEvents()).ifPresent(appEvents -> metadataMap.put(SchemaMetadataType.APP_EVENT, appEvents));
        Optional.ofNullable(schemaApp.getSdkSettings()).ifPresent(sdkSettings -> metadataMap.put(SchemaMetadataType.SDK_SETTING, sdkSettings));
    }

    public static String currentVersion() {
        return version;
    }

    public static Long appId() {
        return appId;
    }

    public static String appCode() {
        return appCode;
    }

    public static String appCodeForDB() {
        return appCodeForDB;
    }

    public static MessageType getMessageType() {
        return messageType;
    }

    public static DeployDetail getDeployDetail() { return deployDetail; }

}
