package com.xforceplus.ultraman.transfer.common.util;

import com.xforceplus.ultraman.transfer.common.constant.Constant;
import com.xforceplus.ultraman.transfer.domain.entity.*;

import java.util.UUID;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/11/12 20:55
 * @since 1.8
 */
public class MessageUtils {

    public static String getRealWsUrl(String host, boolean useSsl) {
        return String.format("%s://%s/websocket",
                useSsl ? Constant.SSL_SOCKET_PREFIX : Constant.NONE_SSL_SOCKET_PREFIX,
                host);
    }

    public static String getUrl(String host, boolean useSsl) {
        return String.format("%s://%s",
                useSsl ? Constant.HTTPS_PREFIX : Constant.HTTP_PREFIX,
                host);
    }

    public static String getUrl(String host, boolean useSsl, String apiUrl) {
        return String.format("%s://%s%s",
                useSsl ? Constant.HTTPS_PREFIX : Constant.HTTP_PREFIX,
                host, apiUrl);
    }

    public static String getSchema(boolean useSsl) {
        return useSsl ? Constant.HTTPS_PREFIX : Constant.HTTP_PREFIX;
    }

    public static TransferMessage buildReplyMessage(TransferMessage message, boolean success, String desc) {
        TransferMessage transferReplyMessage = new TransferMessage();
        transferReplyMessage.setAppId(message.getAppId());
        transferReplyMessage.setEnv(message.getEnv());
        transferReplyMessage.setVersion(message.getVersion());
        transferReplyMessage.setMessageType(message.getMessageType());

        transferReplyMessage.setReplyMessage(true);
        transferReplyMessage.setOrigId(message.getId());
        transferReplyMessage.setHandleSuccess(success);
        transferReplyMessage.setId(UUID.randomUUID().toString());
        transferReplyMessage.setHandleMessage(desc);
        return transferReplyMessage;
    }

}
