package com.xforceplus.ultraman.transfer.common.util;

import java.time.Instant;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 3/31/2020 10:16 AM
 * 功能描述:
 * 修改历史:
 */
public class VersionUtils {

    public final static String START_VERSION = "0.0.0";

    public final static String FIRST_PUBLISHED_VERSION = "0.0.1";

    final static String pattern = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";

    public static boolean checkVersion(String version) {
        //99.99.99999 TODO
        return !StringUtils.isEmpty(version) && Pattern.matches(pattern, version);
    }

    public static String nextVersion(String version) {
        String[] vs = version.split("\\.");

        if (!checkVersion(version) || vs.length < 3 || !StringUtils.isNumeric(vs[0]) || !StringUtils.isNumeric(vs[1]) || !StringUtils.isNumeric(vs[2])) {
            return FIRST_PUBLISHED_VERSION;
        }
        Integer v1 = Integer.parseInt(vs[0]);
        Integer v2 = Integer.parseInt(vs[1]);
        Integer v3 = Integer.parseInt(vs[2]);
        if (v3 >= 99) {
            if (v2 >= 99) {
                v1 += 1;
                v2 = 0;
            } else {
                v2 += 1;
            }
            v3 = 0;
        } else {
            v3 += 1;
        }
        return String.format("%s.%s.%s", v1, v2, v3);
    }


    /**
     * 比较版本 version1 < version2时，返回 -1;比较版本 version1 == version2时，返回 0;比较版本 version1 > version2时，返回 1;
     * 有个特殊版本形式是沙箱的版本sandbox.1692069436745，只要返回不是0就行
     *
     * @param version1
     * @param version2
     * @return
     */
    public static int compare(String version1, String version2) {
        Integer vNum1 = computeVersionInt(version1);
        Integer vNum2 = computeVersionInt(version2);

        if (null == vNum1) {
            return -1;
        }

        if (null == vNum2) {
            return 1;
        }

        return vNum1.compareTo(vNum2);
    }

    public static String sandboxVersion() {
        int version = (int) Instant.now().getEpochSecond();
        String a = String.valueOf(version);
        String b = a.substring(0, 4) + "." + a.substring(4, 7) + "." + a.substring(7, 10);
        return b;
    }

    /**
     * version int
     *
     * @param versionStr
     * @return
     */
    public static Integer computeVersionInt(String versionStr) {
        if (StringUtils.isEmpty(versionStr)) {
            return null;
        }
        String[] vs = versionStr.split("\\.");
        if (vs.length < 3) {
            return null;
        }
        Integer v1 = Integer.parseInt(vs[0]) * 10000000;
        Integer v2 = Integer.parseInt(vs[1]) * 100000;
        Integer v3 = Integer.parseInt(vs[2]) * 100;
        if (vs.length == 4) {
            Integer v4 = Integer.parseInt(vs[3]);
            return v1 + v2 + v3 + v4;
        }
        return v3 + v2 + v1;
    }

    /**
     * version for oqs
     * 因为原先oqs计算版本整数值有问题，所以特别和computeVersionInt方法区分开来
     *
     * @param versionStr
     * @return
     */
    public static Integer computeVersionIntForOqs(String versionStr) {
        if (StringUtils.isEmpty(versionStr)) {
            return null;
        }
        String[] vs = versionStr.split("\\.");
        if (vs.length < 3) {
            return null;
        }
        Integer v1 = Integer.parseInt(vs[0]) * 100000000; // TODO 这里有问题 应该是7个0，现在是8个0；
        Integer v2 = Integer.parseInt(vs[1]) * 100000;
        Integer v3 = Integer.parseInt(vs[2]) * 100;
        if (vs.length == 4) {
            Integer v4 = Integer.parseInt(vs[3]);
            return v1 + v2 + v3 + v4;
        }
        return v3 + v2 + v1;
    }

    public static String convertVersionIntToVersion(Integer versionNum) {
        if (versionNum == null) {
            return null;
        }
        StringBuffer version = new StringBuffer(versionNum.toString());
        int zeroNum = 9 - versionNum.toString().length();
        for (int i = 0; i < zeroNum; i++) {
            version.insert(0, "0");
        }
        return String.format("%s.%s.%s", version.substring(0, 3), version.substring(3, 6), version.substring(6, 9));
    }

}
