/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAction;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaApp;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaAppEvent;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaBo;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaDict;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.transfer.domain.entity.DeployDetail;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MetadataContextHolder {
    private static final Map<SchemaMetadataType, Object> metadataMap = Maps.newConcurrentMap();
    private static volatile Long appId = null;
    private static volatile String appCode = null;
    private static volatile String appCodeForDB = null;
    private static volatile String version = "";
    private static volatile MessageType messageType = null;
    private static volatile DeployDetail deployDetail;

    public static List<SchemaBo> getEntityMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.ENTITY);
    }

    public static List<SchemaDict> getDictMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.DICT);
    }

    public static List<SchemaAction> getActionMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.ACTION);
    }

    public static List<SchemaAppEvent> getAppEventMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.APP_EVENT);
    }

    public static List<SchemaSdkSetting> getSdkSettingMetadata() {
        return (List)metadataMap.get(SchemaMetadataType.SDK_SETTING);
    }

    public static synchronized void init(String appIdStr, TransferMessage transferMessage, SchemaApp schemaApp) {
        version = transferMessage.getVersion();
        messageType = transferMessage.getMessageType();
        deployDetail = transferMessage.getDeployDetail();
        if (!StringUtils.isBlank((CharSequence)appIdStr)) {
            appId = Long.valueOf(appIdStr);
        }
        if (!StringUtils.isBlank((CharSequence)transferMessage.getAppCode())) {
            appCode = transferMessage.getAppCode();
        }
        if (!StringUtils.isBlank((CharSequence)transferMessage.getAppCodeForDB())) {
            appCodeForDB = transferMessage.getAppCodeForDB();
        }
        Optional.ofNullable(schemaApp.getBos()).ifPresent(bos -> metadataMap.put(SchemaMetadataType.ENTITY, bos));
        Optional.ofNullable(schemaApp.getDicts()).ifPresent(dicts -> metadataMap.put(SchemaMetadataType.DICT, dicts));
        Optional.ofNullable(schemaApp.getActions()).ifPresent(actions -> metadataMap.put(SchemaMetadataType.ACTION, actions));
        Optional.ofNullable(schemaApp.getAppEvents()).ifPresent(appEvents -> metadataMap.put(SchemaMetadataType.APP_EVENT, appEvents));
        Optional.ofNullable(schemaApp.getSdkSettings()).ifPresent(sdkSettings -> metadataMap.put(SchemaMetadataType.SDK_SETTING, sdkSettings));
    }

    public static synchronized void update(String appIdStr, TransferMessage transferMessage, SchemaApp schemaApp) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)transferMessage.getVersion()) ? 1 : 0) != 0, (Object)"\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MetadataContextHolder.init(appIdStr, transferMessage, schemaApp);
    }

    public static String currentVersion() {
        return version;
    }

    public static Long appId() {
        return appId;
    }

    public static String appCode() {
        return appCode;
    }

    public static String appCodeForDB() {
        return appCodeForDB;
    }

    public static MessageType getMessageType() {
        return messageType;
    }

    public static DeployDetail getDeployDetail() {
        return deployDetail;
    }
}

