/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.common.util;

import java.time.Instant;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VersionUtils {
    public static final String START_VERSION = "0.0.0";
    public static final String FIRST_PUBLISHED_VERSION = "0.0.1";
    static final String pattern = "^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$";

    public static boolean checkVersion(String version) {
        return !StringUtils.isEmpty((CharSequence)version) && Pattern.matches(pattern, version);
    }

    public static String nextVersion(String version) {
        String[] vs = version.split("\\.");
        if (!(VersionUtils.checkVersion(version) && vs.length >= 3 && StringUtils.isNumeric((CharSequence)vs[0]) && StringUtils.isNumeric((CharSequence)vs[1]) && StringUtils.isNumeric((CharSequence)vs[2]))) {
            return FIRST_PUBLISHED_VERSION;
        }
        Integer v1 = Integer.parseInt(vs[0]);
        Integer v2 = Integer.parseInt(vs[1]);
        Integer v3 = Integer.parseInt(vs[2]);
        if (v3 >= 99) {
            if (v2 >= 99) {
                v1 = v1 + 1;
                v2 = 0;
            } else {
                v2 = v2 + 1;
            }
            v3 = 0;
        } else {
            v3 = v3 + 1;
        }
        return String.format("%s.%s.%s", v1, v2, v3);
    }

    public static int compare(String version1, String version2) {
        Integer vNum1 = VersionUtils.computeVersionInt(version1);
        Integer vNum2 = VersionUtils.computeVersionInt(version2);
        if (null == vNum1) {
            return -1;
        }
        if (null == vNum2) {
            return 1;
        }
        return vNum1.compareTo(vNum2);
    }

    public static String sandboxVersion() {
        int version = (int)Instant.now().getEpochSecond();
        String a = String.valueOf(version);
        String b = a.substring(0, 4) + "." + a.substring(4, 7) + "." + a.substring(7, 10);
        return b;
    }

    public static Integer computeVersionInt(String versionStr) {
        if (StringUtils.isEmpty((CharSequence)versionStr)) {
            return null;
        }
        String[] vs = versionStr.split("\\.");
        if (vs.length < 3) {
            return null;
        }
        Integer v1 = Integer.parseInt(vs[0]) * 10000000;
        Integer v2 = Integer.parseInt(vs[1]) * 100000;
        Integer v3 = Integer.parseInt(vs[2]) * 100;
        if (vs.length == 4) {
            Integer v4 = Integer.parseInt(vs[3]);
            return v1 + v2 + v3 + v4;
        }
        return v3 + v2 + v1;
    }

    public static Integer computeVersionIntForOqs(String versionStr) {
        if (StringUtils.isEmpty((CharSequence)versionStr)) {
            return null;
        }
        String[] vs = versionStr.split("\\.");
        if (vs.length < 3) {
            return null;
        }
        Integer v1 = Integer.parseInt(vs[0]) * 100000000;
        Integer v2 = Integer.parseInt(vs[1]) * 100000;
        Integer v3 = Integer.parseInt(vs[2]) * 100;
        if (vs.length == 4) {
            Integer v4 = Integer.parseInt(vs[3]);
            return v1 + v2 + v3 + v4;
        }
        return v3 + v2 + v1;
    }

    public static String convertVersionIntToVersion(Integer versionNum) {
        if (versionNum == null) {
            return null;
        }
        StringBuffer version = new StringBuffer(versionNum.toString());
        int zeroNum = 9 - versionNum.toString().length();
        for (int i = 0; i < zeroNum; ++i) {
            version.insert(0, "0");
        }
        return String.format("%s.%s.%s", version.substring(0, 3), version.substring(3, 6), version.substring(6, 9));
    }
}

