package com.xforceplus.ultraman.transfer.domain.dto;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.domain.entity.MetadataEntity;
import lombok.Data;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/8/23 19:44
 * Description:
 * History:
 */
@Data
public class MetadataEntityDTO {
    //应用ID
    Long appId;
    //是否部署，目前无用；准备用在数据库多个版本时，标记哪个是正在使用的
    Boolean isDeploy = false;
    //配置唯一键
    Long metadataId;
    //配置类型
    SchemaMetadataType metadataType;
    //配置内容
    String content;
    //应用版本号
    String version;
    //应用版本整数
    Integer versionNumber;
    //租户代码
    String tenantCode;
    //准备用于更广泛的定制标识，不仅仅是租户
    String profile;

    Long refAppId;
    String refAppVersion;

    public MetadataEntity newEntity() {
        MetadataEntity newEntity = new MetadataEntity();
        newEntity.setAppId(this.getAppId());
        newEntity.setDeploy(this.getIsDeploy());
        newEntity.setVersion(this.getVersion());
        newEntity.setVersionNumber(this.getVersionNumber());
        newEntity.setMetadataType(this.getMetadataType().code());
        newEntity.setTenantCode(this.getTenantCode());
        newEntity.setProfile(this.getProfile());
        newEntity.setMetadataId(this.getMetadataId());
        newEntity.setContent(this.getContent());
        return newEntity;
    }
}
