package com.xforceplus.ultraman.transfer.domain.entity;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/11/15 11:44
 * @since 1.8
 */
public class Response<T> {
    public static final String OK = "1";
    public static final String Fail = "-1";
    private String code;
    private String message;
    private T result;

    public Response() {
    }

    public Response(String code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode("1");
        response.setMessage(message);
        return response;
    }

    public static Response failed(String message) {
        Response response = new Response();
        response.setCode("-1");
        response.setMessage(message);
        return response;
    }

    public static Response Error(String message) {
        return failed(message);
    }

    public static Response from(String code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(String code, String message, T result) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "Response{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}
