package com.xforceplus.ultraman.transfer.domain.entity;

import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.transfer.domain.enums.MessageType;
import lombok.Data;

/**
 * .
 *
 * @author leo
 * @version 0.1 2022/10/31 19:39
 * @since 1.8
 */

@Data
public class TransferMessage {
    /**
     * 客户端ID
     */
    private String clientId;
    /**
     * 消息类型
     */
    private MessageType messageType;
    /**
     * 原消息ID
     */
    private String origId;
    /**
     * 消息ID
     */
    private String id;
    /**
     * 应用ID
     */
    private Long appId;
    /**
     * 应用代码
     */
    private String appCode;
    /**
     * 应用类型
     */
    private AppCustomType customType;
    /**
     * 需要部署的版本
     */
    private String version;
    /**
     * 应用原部署版本
     */
    private String originVersion;
    /**
     * 定制应用ID
     */
    private Long refAppId;
    /**
     * 定制应用版本
     */
    private String refAppVersion;
    /**
     * 应用部署环境ID
     */
    private String env;
    /**
     * 是否强制更新
     */
    private boolean forceUpdate;
    /**
     * 是否回复消息
     */
    private boolean isReplyMessage;
    /**
     * 消息处理代码
     */
    private String handleCode;
    /**
     * 消息处理状态 true : 成功  false ： 失败
     */
    private boolean handleSuccess;
    /**
     * 处理详情描述
     */
    private String handleMessage;
    /**
     * 应用代码（用于数据库）后期版本优先从sdkSetting里面取
     */
    private String appCodeForDB;
    /**
     * 部署详情 含有应用租户定制的部署信息等
     */
    private DeployDetail deployDetail;
    /**
     * ddl
     */
    private DdlDetail ddlDetail;
    /**
     * 团队ID
     */
    private Long teamId;
    /**
     * 团队代码
     */
    private String teamCode;

    private boolean firstDeploy;
}
