package com.xforceplus.ultraman.transfer.domain.util;

import com.google.common.collect.Lists;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.*;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2024/4/3 12:06
 * Description:
 * History:
 */
public class MetadataJsonSchemaDomainUtil {

    public static SchemaBo buildSchemaBo(SchemaTenantBo schemaTenant) {
        SchemaBo bo = new SchemaBo();
        bo.setId(schemaTenant.getId());
        bo.setName(schemaTenant.getName());
        bo.setCode(schemaTenant.getCode());
        bo.setAlias(schemaTenant.getAlias());
        bo.setRemark(schemaTenant.getRemark());
        bo.setBoType(schemaTenant.getBoType());
        bo.setSysType(schemaTenant.getSysType());
        bo.setLevel(schemaTenant.getLevel());
        bo.setMode(schemaTenant.getMode());
        bo.setParentBoId(schemaTenant.getParentBoId());
        bo.setSyncBoId(schemaTenant.getSyncBoId());
        bo.setBoFields(schemaTenant.getBoFields());
        bo.setBoApis(schemaTenant.getBoApis());
        bo.setBoDataRules(schemaTenant.getBoDataRules());
        bo.setBoIndexes(schemaTenant.getBoIndexes());
        bo.setBoRelationships(schemaTenant.getBoRelationships());
        return bo;
    }
    
    public static SchemaDict buildSchemaDict(SchemaTenantDict schemaTenant) {
        SchemaDict dict = new SchemaDict();
        dict.setId(schemaTenant.getId());
        dict.setName(schemaTenant.getName());
        dict.setCode(schemaTenant.getCode());
        dict.setAlias(schemaTenant.getAlias());
        dict.setRemark(schemaTenant.getRemark());
        dict.setSystemType(schemaTenant.getSystemType());
        dict.setTenantDicts(Lists.newArrayList(schemaTenant));
        return dict;
    }

    public static SchemaPage buildSchemaPage(SchemaTenantPage schemaTenant) {
        SchemaPage page = new SchemaPage();
        page.setId(schemaTenant.getId());
        page.setName(schemaTenant.getName());
        page.setCode(schemaTenant.getCode());
        page.setAlias(schemaTenant.getAlias());
        page.setRemark(schemaTenant.getRemark());
        page.setTenantPages(Lists.newArrayList(schemaTenant));
        return page;
    }

    public static SchemaPageSetting buildSchemaPageSetting(SchemaTenantPageSetting schemaTenant) {
        SchemaPageSetting pageSetting = new SchemaPageSetting();
        pageSetting.setId(schemaTenant.getId());
        pageSetting.setName(schemaTenant.getName());
        pageSetting.setCode(schemaTenant.getCode());
        pageSetting.setAlias(schemaTenant.getAlias());
        pageSetting.setRemark(schemaTenant.getRemark());
        pageSetting.setTenantPageSettings(Lists.newArrayList(schemaTenant));
        return pageSetting;
    }

    public static SchemaForm buildSchemaForm(SchemaTenantForm schemaTenant) {
        SchemaForm form = new SchemaForm();
        form.setId(schemaTenant.getId());
        form.setName(schemaTenant.getName());
        form.setCode(schemaTenant.getCode());
        form.setAlias(schemaTenant.getAlias());
        form.setRemark(schemaTenant.getRemark());
        form.setTenantForms(Lists.newArrayList(schemaTenant));
        return form;
    }

    public static SchemaFlow buildSchemaFlow(SchemaTenantFlow schemaTenant) {
        SchemaFlow flow = new SchemaFlow();
        flow.setId(schemaTenant.getId());
        flow.setName(schemaTenant.getName());
        flow.setCode(schemaTenant.getCode());
        flow.setRemark(schemaTenant.getRemark());
        flow.setFlowType(schemaTenant.getFlowType());
        flow.setVersion(schemaTenant.getVersion());
        flow.setTenantFlows(Lists.newArrayList(schemaTenant));
        return flow;
    }

    public static SchemaAppI18nResource buildSchemaAppI18nResource(SchemaTenantAppI18nResource schemaTenant) {
        SchemaAppI18nResource data = new SchemaAppI18nResource();
        data.setId(schemaTenant.getId());
        data.setType(schemaTenant.getType());
        data.setResourceName(schemaTenant.getResourceName());
        data.setResourceCode(schemaTenant.getResourceCode());
        data.setResourceContent(schemaTenant.getResourceContent());
        data.setMetadataId(schemaTenant.getMetadataId());
        data.setMetadataParentId(schemaTenant.getMetadataParentId());
        return data;
    }

    public static SchemaAppI18nLocale buildSchemaAppI18nLocale(SchemaTenantAppI18nLocale schemaTenant) {
        SchemaAppI18nLocale data = new SchemaAppI18nLocale();
        data.setId(schemaTenant.getId());
        data.setLanguageCode(schemaTenant.getLanguageCode());
        data.setRegionCode(schemaTenant.getRegionCode());
        return data;
    }
    
}
