package com.xforceplus.ultraman.transfer.domain.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum AppEnv {

    /**
     * FAT 环境
     */
    FAT("1","fat"),

    /**
     *  开发环境
     */
    DEV("0","dev"),

    /**
     *  sit环境
     */
    SIT("3","sit"),

    /**
     * 生产环境
     */
    PROD("2","prod");



    @JsonValue
    private String value;

    private String description;

    AppEnv(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public String desc() {
        return this.description;
    }

    public static AppEnv fromValue(String value) {
        return Stream.of(AppEnv.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在Bocp环境类型！"));
    }

}
