/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.aliyunoss.api;

import com.aliyun.oss.OSS;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.domain.dto.AppInfo;
import com.xforceplus.ultraman.transfer.domain.dto.MetadataEntityDTO;
import com.xforceplus.ultraman.transfer.domain.dto.MetadataStr;
import com.xforceplus.ultraman.transfer.storage.aliyunoss.constant.AliyunOSSConstant;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssMetadataStorage
implements IMetadataStorage {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssMetadataStorage.class);
    private final OSS ossClient;

    public AliyunOssMetadataStorage(OSS ossClient) {
        this.ossClient = ossClient;
    }

    public boolean isPersistent() {
        return false;
    }

    public AppInfo getLatestAppInfo(Long appId) {
        return null;
    }

    public void saveMetadata(MetadataEntityDTO dto, String jsonStr) {
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            this.saveMetadata(dto.getAppId(), dto.getVersion(), dto.getMetadataType(), jsonStr);
        } else {
            String filePath = AliyunOSSConstant.getTenantMetadataFilePath(dto.getAppId(), dto.getTenantCode(), dto.getVersion(), dto.getMetadataType());
            this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
        }
    }

    public void saveMetadata(MetadataEntityDTO dto, Map<String, String> jsonStrMap) {
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            this.saveMetadata(dto.getAppId(), dto.getVersion(), dto.getMetadataType(), jsonStrMap);
        } else {
            Optional.ofNullable(jsonStrMap).ifPresent(map -> map.keySet().forEach(key -> {
                String filePath = AliyunOSSConstant.getTenantMetadatasFilePath(dto.getAppId(), dto.getTenantCode(), dto.getVersion(), dto.getMetadataType(), key);
                this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(((String)jsonStrMap.get(key)).getBytes(StandardCharsets.UTF_8)));
            }));
        }
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrMap) {
        Optional.ofNullable(jsonStrMap).ifPresent(map -> map.keySet().forEach(key -> {
            String filePath = AliyunOSSConstant.getMetadatasFilePath(appId, version, metadataType, key);
            this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(((String)jsonStrMap.get(key)).getBytes(StandardCharsets.UTF_8)));
        }));
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        String filePath = AliyunOSSConstant.getMetadataFilePath(appId, version, metadataType);
        this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
    }

    public MetadataStr loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        String filePath = AliyunOSSConstant.getMetadataFilePath(appId, version, metadataType);
        return this.getDataStrFromOSS(filePath);
    }

    public List<MetadataStr> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        Map<String, String> contentMap = this.loadMetadataMap(appId, version, metadataType);
        return contentMap.entrySet().stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setMetadataId((String)x.getKey());
            metadataStr.setJsonContent((String)x.getValue());
            return metadataStr;
        }).collect(Collectors.toList());
    }

    public Map<String, String> loadMetadataMap(Long appId, String version, SchemaMetadataType metadataType) {
        String filePathDir = AliyunOSSConstant.getMetadatasDirPath(appId, version, metadataType);
        return this.getDataMapFromOSS(filePathDir);
    }

    public MetadataStr loadMetadataStr(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        String filePath = AliyunOSSConstant.getTenantMetadataFilePath(stdAppId, tenantCode, tenantAppVersion, metadataType);
        return this.getDataStrFromOSS(filePath);
    }

    public List<MetadataStr> loadMetadataStrs(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        Map<String, String> contentMap = this.loadMetadataMap(stdAppId, tenantAppId, tenantCode, tenantAppVersion, metadataType);
        return contentMap.entrySet().stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setMetadataId((String)x.getKey());
            metadataStr.setJsonContent((String)x.getValue());
            return metadataStr;
        }).collect(Collectors.toList());
    }

    public Map<String, String> loadMetadataMap(Long stdAppId, Long tenantappId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        String filePathDir = AliyunOSSConstant.getTenantMetadatasDirPath(stdAppId, tenantCode, tenantAppVersion, metadataType);
        return this.getDataMapFromOSS(filePathDir);
    }

    private MetadataStr getDataStrFromOSS(String filePath) {
        try {
            if (!this.ossClient.doesObjectExist("xforcecloud", filePath)) {
                log.debug("filePath {} not found in oss", (Object)filePath);
                return null;
            }
            OSSObject ossObject = this.ossClient.getObject("xforcecloud", filePath);
            String jsonContent = IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setJsonContent(jsonContent);
            metadataStr.setMetadataId(null);
            return metadataStr;
        }
        catch (Exception e) {
            log.error("could not load tenant metadata", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> getDataMapFromOSS(String filePathDir) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        try {
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName("xforcecloud");
            request.setPrefix(filePathDir);
            request.setMaxKeys(AliyunOSSConstant.MAX_RETURNED_KEYS_LIMIT);
            ObjectListing objectListing = this.ossClient.listObjects(request);
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                OSSObject ossObject = this.ossClient.getObject("xforcecloud", s.getKey());
                contentMap.put(AliyunOSSConstant.getFileName(s.getKey()), IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8"));
            }
        }
        catch (Exception e) {
            log.error("could not load metadata", (Throwable)e);
        }
        return contentMap;
    }
}

