package com.xforceplus.ultraman.transfer.storage.aliyunoss.constant;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/20 18:17
 * Description:
 * History:
 */
public class AliyunOSSConstant {

    public static final String BUCKET_NAME = "xforcecloud";

    public static final String METADATA_FILE = "ultraman/apps/%s/v/%s/%s.json";

    public static final String METADATA_S_FILE = "ultraman/apps/%s/v/%s/%s/%s.json";

    public static final String METADATA_S_PATH = "ultraman/apps/%s/v/%s/%s/";

    public static String getMetadataFilePath(Long appId, String version, SchemaMetadataType metadataType) {
        return String.format(METADATA_FILE, appId, version, metadataType.code());
    }

    public static String getMetadatasFilePath(Long appId, String version, SchemaMetadataType metadataType, String key) {
        return String.format(METADATA_S_FILE, appId, version, metadataType.code(), key);
    }

    public static String getMetadatasDirPath(Long appId, String version, SchemaMetadataType metadataType) {
        return String.format(METADATA_S_PATH, appId, version, metadataType.code());
    }

    public static String getFileName(String filePath) {
        String[] parts = filePath.split("/");
        if (parts.length > 0) {
            String fileNameWithExt = parts[parts.length - 1];
            if (fileNameWithExt.contains(".")) {
                return fileNameWithExt.split("\\.")[0];
            }
        }
        throw new IllegalArgumentException(String.format("illegal file path: %s", filePath));
    }
}
