/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.aliyunoss.api;

import com.aliyun.oss.OSS;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.storage.aliyunoss.constant.AliyunOSSConstant;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssMetadataStorage
implements IMetadataStorage {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssMetadataStorage.class);
    private OSS ossClient;

    public AliyunOssMetadataStorage(OSS ossClient) {
        this.ossClient = ossClient;
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrMap) {
        Optional.ofNullable(jsonStrMap).ifPresent(map -> map.keySet().forEach(key -> {
            String filePath = AliyunOSSConstant.getMetadatasFilePath(appId, version, metadataType, key);
            this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(((String)jsonStrMap.get(key)).getBytes(StandardCharsets.UTF_8)));
        }));
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        String filePath = AliyunOSSConstant.getMetadataFilePath(appId, version, metadataType);
        this.ossClient.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
    }

    public String loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        try {
            String filePath = AliyunOSSConstant.getMetadataFilePath(appId, version, metadataType);
            if (!this.ossClient.doesObjectExist("xforcecloud", filePath)) {
                log.debug("app {} version {} metadata {} not found in oss", new Object[]{appId, version, metadataType.code()});
                return null;
            }
            OSSObject ossObject = this.ossClient.getObject("xforcecloud", filePath);
            return IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("could not load metadata", (Throwable)e);
            return null;
        }
    }

    public List<String> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        Map<String, String> contentMap = this.loadMetadataMap(appId, version, metadataType);
        return contentMap.values().stream().collect(Collectors.toList());
    }

    public Map<String, String> loadMetadataMap(Long appId, String version, SchemaMetadataType metadataType) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        try {
            String filePathDir = AliyunOSSConstant.getMetadatasDirPath(appId, version, metadataType);
            ObjectListing objectListing = this.ossClient.listObjects("xforcecloud", filePathDir);
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                OSSObject ossObject = this.ossClient.getObject("xforcecloud", s.getKey());
                contentMap.put(AliyunOSSConstant.getFileName(s.getKey()), IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8"));
            }
        }
        catch (Exception e) {
            log.error("could not load metadata", (Throwable)e);
        }
        return contentMap;
    }
}

