package com.xforceplus.ultraman.transfer.storage.http.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import okhttp3.HttpUrl;
import okhttp3.Request;

public class JanusHttpStorage extends HttpMetadataStorage {

    private Boolean useSsl;
    
    private String janusBase;
    
    private String authentication;
    
    private String uiaSign;
    
    private String action;
    
    public JanusHttpStorage(String janusBase, String authentication, String uiaSign, String action, Boolean useSsl) {
        super(useSsl);
        this.useSsl = useSsl;
        this.janusBase = janusBase;
        this.authentication = authentication;
        this.uiaSign = uiaSign;
        this.action = action;
    }

    @Override
    protected Request buildRequest(Long appId, String version, SchemaMetadataType metadataType) {
        
        String url = janusBase;
        HttpUrl hostUrl = HttpUrl.get(url);

        HttpUrl httpUrl = new HttpUrl
                .Builder()
                .scheme(MessageUtils.getSchema(useSsl))
                .host(hostUrl.host())
                .port(hostUrl.port())   // 添加路径段，如果有多个路径段，可以多次调用这个方法
                .addQueryParameter("appId", appId.toString())  // 添加查询参数
                .addQueryParameter("metadataType", metadataType.code())// 添加查询参数
                .build();
        
        return new Request.Builder()
                .addHeader("version", version)
                .addHeader("Authentication", authentication)
                .addHeader("serialNo", appId.toString())
                .addHeader("uiaSign", uiaSign)
                .addHeader("action", action)
                .url(httpUrl)
                .build();
    }
}
