package com.xforceplus.ultraman.transfer.storage.http.interceptor;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class RetryInterceptor implements Interceptor {

    private static final String TAG = "NetworkLib: " + "RetryInterceptor";

    private static final int NUMBER_OF_RETRIES = 4;
    private static final double RETRY_DELAY = 300;

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request request = chain.request();
        // try the request
        final Response[] response = {chain.proceed(request)};
        int tryCount = 0;
        while (!response[0].isSuccessful() && tryCount < NUMBER_OF_RETRIES) {
            int expDelay = (int) (RETRY_DELAY * Math.pow(2, Math.max(0, NUMBER_OF_RETRIES - 1)));
            tryCount++;
            try {
                Thread.sleep(expDelay);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            CompletableFuture.runAsync(() -> {
                try {
                    response[0] = chain.call().clone().execute();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        // otherwise just pass the original response on
        return response[0];
    }

}
