package com.xforceplus.ultraman.transfer.storage.http.token;

import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/5/15 15:07
 * Description:
 * History:
 */
public class TokenManager {
    private static final int TOKEN_EXPIRATION_HOURS = 8;

    private static final String TOKEN_KEY = "token";

    private final ConcurrentHashMap<String, String> tokenCache = new ConcurrentHashMap<>();
    private LocalDateTime tokenExpirationTime;

    private BocpGatewayTokenClient gatewayTokenClient;

    public TokenManager(BocpGatewayTokenClient gatewayTokenClient) {
        this.gatewayTokenClient = gatewayTokenClient;
    }

    public String getToken() {
        // 快速检查 token 是否过期
        if (tokenCache.get(TOKEN_KEY) == null || LocalDateTime.now().isAfter(tokenExpirationTime)) {
            synchronized (this) {
                // 再次检查 token 是否过期
                if (tokenCache.get(TOKEN_KEY) == null || LocalDateTime.now().isAfter(tokenExpirationTime)) {
                    // replace "newToken" and "newExpirationTime" with the actual logic to retrieve the token and its expiration time
                    String newToken = retrieveNewToken();
                    tokenCache.put(TOKEN_KEY, newToken);
                    tokenExpirationTime = LocalDateTime.now().plusHours(TOKEN_EXPIRATION_HOURS);
                }
            }
        }
        return tokenCache.get(TOKEN_KEY);
    }

    private String retrieveNewToken() {
        return gatewayTokenClient.queryTokenFromGateway();
    }
}
