package com.xforceplus.ultraman.transfer.storage.http;

import com.xforceplus.ultraman.transfer.storage.http.dto.CustomResponse;
import lombok.SneakyThrows;
import okhttp3.*;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/5/15 15:34
 * Description:
 * History:
 */
public class BocpOkHttpClient {

    public static final MediaType MEDIA_TYPE_JSON
            = MediaType.get("application/json; charset=utf-8");

    public OkHttpClient buildClient(boolean useSsl) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder()
                .retryOnConnectionFailure(true)
                .readTimeout(120, TimeUnit.SECONDS);
        setSSL(builder, useSsl);

        return builder.build();
    }

    public OkHttpClient buildClient(boolean useSsl, List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder()
                .retryOnConnectionFailure(true)
                .readTimeout(120, TimeUnit.SECONDS);
        interceptors.forEach(i -> builder.addInterceptor(i));
        setSSL(builder, useSsl);
        return builder.build();
    }

    @SneakyThrows
    private void setSSL(OkHttpClient.Builder builder, boolean useSsl){
        if (useSsl) {
            //默认信任所有证书
            final X509TrustManager trustManager = new X509TrustManager() {
                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager)
                    .hostnameVerifier((s, sslSession) -> true);
        }
    }

    public boolean isFail(CustomResponse customResponse) {
        return !"1".equals(customResponse.getCode());
    }

}
