package com.xforceplus.ultraman.transfer.storage.http.api;

import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.BocpOkHttpClient;
import com.xforceplus.ultraman.transfer.storage.http.dto.CustomResponse;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/5/15 13:33
 * Description:
 * History:
 */
@Slf4j
public class HttpMetadataStorage extends BocpOkHttpClient implements IMetadataStorage {

    public final String GET_METADATA_PATH = "%smetadatas/versions/%s";
    private String bocpHost;
    private Boolean useSsl;
    private String apiPrefix;
    private final OkHttpClient client;
    public HttpMetadataStorage(
            String bocpHost,
            Boolean useSsl,
            String apiPrefix,
            MetadataHeadInterceptor metadataHeadInterceptor) {
        this.bocpHost = bocpHost;
        this.useSsl = useSsl;
        this.apiPrefix = apiPrefix;
        this.client = buildClient(useSsl, Arrays.asList(metadataHeadInterceptor));
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        return requestMetadata(appId, version, metadataType);
    }

    /**
     * http请求到的flows列表是在一个json里面，不需要该方法
     * @param appId
     * @param version
     * @param metadataType
     * @return
     */
    @Override
    public List<String> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        throw new UnsupportedOperationException();
    }

    private String requestMetadata(Long appId, String version, SchemaMetadataType metadataType) {
        Request request = buildRequest(appId, version, metadataType);
        try (Response resp = client.newCall(request).execute()) {
            if (!resp.isSuccessful()) {
                throw new RuntimeException("调用获取元数据接口失败, msg = " + resp.message());
            }
            CustomResponse response = JsonUtils.json2Object(resp.body().string(), CustomResponse.class);
            if (isFail(response)) {
                throw new RuntimeException("调用获取元数据接口失败, msg = " + resp.message());
            }
            log.info("调用获取元数据接口成功 {}", metadataType.code());
            return response.getData();
        } catch (Exception e) {
//            log.error("调用获取元数据接口失败", e);
            throw new RuntimeException(e);
        }
    }

    private Request buildRequest(Long appId, String version, SchemaMetadataType metadataType) {
        String realApiPrefix = StringUtils.isBlank(apiPrefix) ? "" : apiPrefix + "/";
        String realApiPath = String.format(GET_METADATA_PATH, realApiPrefix, version);
        String url = MessageUtils.getUrl(bocpHost, useSsl);
        HttpUrl hostUrl = HttpUrl.get(url);

        HttpUrl httpUrl = new HttpUrl.Builder()
                .scheme(MessageUtils.getSchema(useSsl))
                .host(hostUrl.host())
                .port(hostUrl.port())
                .addPathSegments(realApiPath)  // 添加路径段，如果有多个路径段，可以多次调用这个方法
                .addQueryParameter("appId", appId.toString())  // 添加查询参数
                .addQueryParameter("metadataType", metadataType.code())// 添加查询参数
                .build();
        return new Request.Builder()
                .url(httpUrl)
                .build();
    }

}
