package com.xforceplus.ultraman.transfer.storage.http.interceptor;

import com.xforceplus.ultraman.transfer.storage.http.token.TokenManager;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/5/15 15:13
 * Description:
 * History:
 */
public class MetadataHeadInterceptor implements Interceptor {

    private final String USER_INFO_KEY = "x-userinfo";
    private final String TOKEN_KEY = "x-app-token";

    private TokenManager tokenManager;

    public MetadataHeadInterceptor(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request newRequest = originalRequest.newBuilder()
                .addHeader(TOKEN_KEY, tokenManager.getToken())
//                .addHeader(USER_INFO_KEY, )
                .build();
        return chain.proceed(newRequest);
    }
}
