package com.xforceplus.ultraman.transfer.storage.http.token;

import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.storage.http.dto.CustomResponse;
import lombok.extern.slf4j.Slf4j;
import com.xforceplus.ultraman.transfer.storage.http.BocpOkHttpClient;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class GatewayTokenClient extends BocpOkHttpClient {

    public final String GET_TOKEN_PATH = "/api/client/login";

    private String authUrl;

    private String clientId;

    private String secret;

    private final OkHttpClient client;

    public GatewayTokenClient(
            String authUrl, String clientId, String secret) {
        if (StringUtils.isBlank(clientId) || StringUtils.isBlank(secret)) {
            throw new IllegalArgumentException("网关秘钥不能为空, 请确认clientId跟secret已配置!");
        }
        this.authUrl = authUrl;
        this.clientId = clientId;
        this.secret = secret;
        this.client = buildClient(HttpUrl.get(authUrl).isHttps());
    }

    public String queryTokenFromGateway() {
        Map jsonMap = new HashMap<>();
        jsonMap.put("clientId", clientId);
        jsonMap.put("secret", secret);

        RequestBody body = RequestBody.create(MEDIA_TYPE_JSON, JsonUtils.object2Json(jsonMap));
        Request request = buildRequest(body);
        try (Response resp = client.newCall(request).execute()) {
            if (!resp.isSuccessful()) {
                throw new RuntimeException("调用网关获取token失败, msg = " + resp.message());
            }
            CustomResponse tokenBody = JsonUtils.json2Object(resp.body().string(), CustomResponse.class);
            if (isFail(tokenBody)) {
                throw new RuntimeException("调用网关获取token失败, msg = " + resp.message());
            }
            return tokenBody.getData();
        } catch (Exception e) {
            log.error("调用网关失败", e);
            throw new RuntimeException(e);
        }
    }

    private Request buildRequest(RequestBody body) {
        String realAuthUrl = authUrl + GET_TOKEN_PATH;
        HttpUrl httpUrl = HttpUrl.get(realAuthUrl);

        return new Request.Builder()
                .url(httpUrl)
                .post(body)
                .build();
    }



}
