/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.http.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.common.util.MessageUtils;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import com.xforceplus.ultraman.transfer.storage.http.BocpOkHttpClient;
import com.xforceplus.ultraman.transfer.storage.http.dto.CustomResponse;
import com.xforceplus.ultraman.transfer.storage.http.interceptor.MetadataHeadInterceptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMetadataStorage
extends BocpOkHttpClient
implements IMetadataStorage {
    private static final Logger log = LoggerFactory.getLogger(HttpMetadataStorage.class);
    public final String GET_METADATA_PATH = "%smetadatas/versions/%s";
    private String bocpHost;
    private Boolean useSsl;
    private String apiPrefix;
    private final OkHttpClient client;

    public HttpMetadataStorage(String bocpHost, Boolean useSsl, String apiPrefix, MetadataHeadInterceptor metadataHeadInterceptor) {
        this.bocpHost = bocpHost;
        this.useSsl = useSsl;
        this.apiPrefix = apiPrefix;
        this.client = this.buildClient(useSsl, Arrays.asList(metadataHeadInterceptor));
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        throw new UnsupportedOperationException();
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrs) {
        throw new UnsupportedOperationException();
    }

    public String loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        return this.requestMetadata(appId, version, metadataType);
    }

    public List<String> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String requestMetadata(Long appId, String version, SchemaMetadataType metadataType) {
        Request request = this.buildRequest(appId, version, metadataType);
        try (Response resp = this.client.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5143\u6570\u636e\u63a5\u53e3\u5931\u8d25, msg = " + resp.message());
            }
            CustomResponse response = (CustomResponse)JsonUtils.json2Object((String)resp.body().string(), CustomResponse.class);
            if (this.isFail(response)) {
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5143\u6570\u636e\u63a5\u53e3\u5931\u8d25, msg = " + resp.message());
            }
            log.info("\u8c03\u7528\u83b7\u53d6\u5143\u6570\u636e\u63a5\u53e3\u6210\u529f {}", (Object)metadataType.code());
            String string = response.getData();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Request buildRequest(Long appId, String version, SchemaMetadataType metadataType) {
        String realApiPrefix = StringUtils.isBlank((CharSequence)this.apiPrefix) ? "" : this.apiPrefix + "/";
        String realApiPath = String.format("%smetadatas/versions/%s", realApiPrefix, version);
        String url = MessageUtils.getUrl((String)this.bocpHost, (boolean)this.useSsl);
        HttpUrl hostUrl = HttpUrl.get((String)url);
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(MessageUtils.getSchema((boolean)this.useSsl)).host(hostUrl.host()).port(hostUrl.port()).addPathSegments(realApiPath).addQueryParameter("appId", appId.toString()).addQueryParameter("metadataType", metadataType.code()).build();
        return new Request.Builder().url(httpUrl).build();
    }
}

