/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.http.token;

import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.storage.http.BocpOkHttpClient;
import com.xforceplus.ultraman.transfer.storage.http.dto.CustomResponse;
import java.util.HashMap;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayTokenClient
extends BocpOkHttpClient {
    private static final Logger log = LoggerFactory.getLogger(GatewayTokenClient.class);
    public final String GET_TOKEN_PATH = "/api/client/login";
    private String authUrl;
    private String clientId;
    private String secret;
    private final OkHttpClient client;

    public GatewayTokenClient(String authUrl, String clientId, String secret) {
        if (StringUtils.isBlank((CharSequence)clientId) || StringUtils.isBlank((CharSequence)secret)) {
            throw new IllegalArgumentException("\u7f51\u5173\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u786e\u8ba4clientId\u8ddfsecret\u5df2\u914d\u7f6e!");
        }
        this.authUrl = authUrl;
        this.clientId = clientId;
        this.secret = secret;
        this.client = this.buildClient(HttpUrl.get((String)authUrl).isHttps());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String queryTokenFromGateway() {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("clientId", this.clientId);
        jsonMap.put("secret", this.secret);
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)JsonUtils.object2Json(jsonMap));
        Request request = this.buildRequest(body);
        try (Response resp = this.client.newCall(request).execute();){
            if (!resp.isSuccessful()) {
                throw new RuntimeException("\u8c03\u7528\u7f51\u5173\u83b7\u53d6token\u5931\u8d25, msg = " + resp.message());
            }
            CustomResponse tokenBody = (CustomResponse)JsonUtils.json2Object((String)resp.body().string(), CustomResponse.class);
            if (this.isFail(tokenBody)) {
                throw new RuntimeException("\u8c03\u7528\u7f51\u5173\u83b7\u53d6token\u5931\u8d25, msg = " + resp.message());
            }
            String string = tokenBody.getData();
            return string;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u5173\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Request buildRequest(RequestBody body) {
        String realAuthUrl = this.authUrl + "/api/client/login";
        HttpUrl httpUrl = HttpUrl.get((String)realAuthUrl);
        return new Request.Builder().url(httpUrl).post(body).build();
    }
}

