/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.http.token;

import com.xforceplus.ultraman.transfer.storage.http.token.GatewayTokenClient;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;

public class TokenManager {
    private static final int TOKEN_EXPIRATION_HOURS = 8;
    private static final String TOKEN_KEY = "token";
    private final ConcurrentHashMap<String, String> tokenCache = new ConcurrentHashMap();
    private LocalDateTime tokenExpirationTime;
    private GatewayTokenClient gatewayTokenClient;

    public TokenManager(GatewayTokenClient gatewayTokenClient) {
        this.gatewayTokenClient = gatewayTokenClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        if (this.tokenCache.get(TOKEN_KEY) == null || LocalDateTime.now().isAfter(this.tokenExpirationTime)) {
            TokenManager tokenManager = this;
            synchronized (tokenManager) {
                if (this.tokenCache.get(TOKEN_KEY) == null || LocalDateTime.now().isAfter(this.tokenExpirationTime)) {
                    String newToken = this.retrieveNewToken();
                    this.tokenCache.put(TOKEN_KEY, newToken);
                    this.tokenExpirationTime = LocalDateTime.now().plusHours(8L);
                }
            }
        }
        return this.tokenCache.get(TOKEN_KEY);
    }

    private String retrieveNewToken() {
        return this.gatewayTokenClient.queryTokenFromGateway();
    }
}

