package com.xforceplus.ultraman.transfer.storage.localfile.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/20 17:57
 * Description:
 * History:
 */
public class LocalFileMetadataStorage implements IMetadataStorage {
    private String filePrefix;

    private final String METADATA_PATH = "%s/apps/%s/v/%s/%s.json";

    private final String METADATA_S_PATH = "%s/apps/%s/v/%s/%s/%s.json";

    public LocalFileMetadataStorage(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        String fullPath = String.format(METADATA_PATH, filePrefix, appId, version, metadataType);
        try (FileOutputStream fos = new FileOutputStream(fullPath); ObjectOutputStream oos = new ObjectOutputStream(fos)) {
            oos.writeUTF(jsonStr);
        } catch (IOException e) {
            throw new RuntimeException("Failed to save metadata to local file system.", e);
        }
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrs) {
        Optional.ofNullable(jsonStrs).ifPresent(jStrs -> {
            jStrs.keySet().forEach(key -> {
                String fullPath = String.format(METADATA_S_PATH, filePrefix, appId, version, metadataType, key);
                try (FileOutputStream fos = new FileOutputStream(fullPath); ObjectOutputStream oos = new ObjectOutputStream(fos)) {
                    oos.writeUTF(jsonStrs.get(key));
                } catch (IOException e) {
                    throw new RuntimeException("Failed to save metadata to local file system.", e);
                }
            });
        });
    }

    @Override
    public String loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        String fullPath = String.format(METADATA_PATH, filePrefix, appId, version, metadataType);
        try (FileInputStream fis = new FileInputStream(fullPath);
             ObjectInputStream ois = new ObjectInputStream(fis)) {
            return ois.readUTF();
        } catch (IOException e) {
            throw new RuntimeException("Failed to load metadata from local file system.", e);
        }
    }

    @Override
    public List<String> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        String filePathDir = String.format(METADATA_S_PATH, filePrefix, appId, version, metadataType);
        try (Stream<Path> paths = Files.walk(Paths.get(filePathDir))) {
            return paths
                    .filter(Files::isRegularFile)
                    .map(Path::toString)
                    .collect(Collectors.toList());
        } catch (IOException e) {
            throw new RuntimeException("Failed to load metadata from local file system.", e);
        }
    }
}
