/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.transfer.storage.localfile.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LocalFileMetadataStorage
implements IMetadataStorage {
    private String filePrefix;
    private final String METADATA_PATH = "%s/apps/%s/v/%s/%s.json";
    private final String METADATA_S_PATH = "%s/apps/%s/v/%s/%s/%s.json";

    public LocalFileMetadataStorage(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        String fullPath = String.format("%s/apps/%s/v/%s/%s.json", this.filePrefix, appId, version, metadataType);
        try (FileOutputStream fos = new FileOutputStream(fullPath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeUTF(jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save metadata to local file system.", e);
        }
    }

    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrs) {
        Optional.ofNullable(jsonStrs).ifPresent(jStrs -> jStrs.keySet().forEach(key -> {
            String fullPath = String.format("%s/apps/%s/v/%s/%s/%s.json", this.filePrefix, appId, version, metadataType, key);
            try (FileOutputStream fos = new FileOutputStream(fullPath);
                 ObjectOutputStream oos = new ObjectOutputStream(fos);){
                oos.writeUTF((String)jsonStrs.get(key));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save metadata to local file system.", e);
            }
        }));
    }

    /*
     * Exception decompiling
     */
    public String loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        String filePathDir = String.format("%s/apps/%s/v/%s/%s/%s.json", this.filePrefix, appId, version, metadataType);
        try (Stream<Path> paths = Files.walk(Paths.get(filePathDir, new String[0]), new FileVisitOption[0]);){
            List<String> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load metadata from local file system.", e);
        }
    }
}

