package com.xforceplus.ultraman.transfer.storage.localfile.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.domain.dto.AppInfo;
import com.xforceplus.ultraman.transfer.domain.dto.MetadataStr;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/20 17:57
 * Description:
 * History:
 */
public class LocalFileMetadataStorage implements IMetadataStorage {
    private String filePrefix;

    private final String METADATA_PATH = "%s/apps/%s/v/%s/%s.json";

    private final String METADATA_S_PATH = "%s/apps/%s/v/%s/%s/%s.json";

    private final String METADATA_TENANT_PATH = "%s/apps/%s/tenants/%s/v/%s/%s.json";

    private final String METADATA_S_TENANT_PATH = "%s/apps/%s/tenants/%s/v/%s/%s";


    public LocalFileMetadataStorage(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public AppInfo getLatestAppInfo(Long appId) {
        return null;
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        String fullPath = String.format(METADATA_PATH, filePrefix, appId, version, metadataType);
        try (FileOutputStream fos = new FileOutputStream(fullPath); ObjectOutputStream oos = new ObjectOutputStream(fos)) {
            oos.writeUTF(jsonStr);
        } catch (IOException e) {
            throw new RuntimeException("Failed to save metadata to local file system.", e);
        }
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrs) {
        Optional.ofNullable(jsonStrs).ifPresent(jStrs ->
            jStrs.keySet().forEach(key -> {
                String fullPath = String.format(METADATA_S_PATH, filePrefix, appId, version, metadataType, key);
                try (FileOutputStream fos = new FileOutputStream(fullPath); ObjectOutputStream oos = new ObjectOutputStream(fos)) {
                    oos.writeUTF(jsonStrs.get(key));
                } catch (IOException e) {
                    throw new RuntimeException("Failed to save metadata to local file system.", e);
                }
            })
        );
    }

    @Override
    public MetadataStr loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        String filePath = String.format(METADATA_PATH, filePrefix, appId, version, metadataType);
        String dataStr = getDataStr(filePath);
        MetadataStr metadataStr = new MetadataStr();
        metadataStr.setJsonContent(dataStr);
        return metadataStr;
    }

    @Override
    public List<MetadataStr> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        String filePathDir = String.format(METADATA_S_PATH, filePrefix, appId, version, metadataType);
        List<String> dataStrs = getDataStrs(filePathDir);
        return dataStrs.stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setJsonContent(x);
            return metadataStr;
        }).collect(Collectors.toList());
    }

    @Override
    public MetadataStr loadMetadataStr(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        String filePath = String.format(METADATA_TENANT_PATH, filePrefix, stdAppId, tenantCode, tenantAppVersion, metadataType);
        String dataStr = getDataStr(filePath);
        MetadataStr metadataStr = new MetadataStr();
        metadataStr.setJsonContent(dataStr);
        return metadataStr;
    }

    @Override
    public List<MetadataStr> loadMetadataStrs(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        String filePathDir = String.format(METADATA_S_TENANT_PATH, filePrefix, stdAppId, tenantCode, tenantAppVersion, metadataType);
        List<String> dataStrs = getDataStrs(filePathDir);
        return dataStrs.stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setJsonContent(x);
            return metadataStr;
        }).collect(Collectors.toList());
    }

    private String getDataStr(String filePath) {
        try (FileInputStream fis = new FileInputStream(filePath);
             ObjectInputStream ois = new ObjectInputStream(fis)) {
            return ois.readUTF();
        } catch (IOException e) {
            throw new RuntimeException("Failed to load metadata from local file system.", e);
        }
    }

    private List<String> getDataStrs(String filePathDir) {
        try (Stream<Path> paths = Files.walk(Paths.get(filePathDir))) {
            return paths
                    .filter(Files::isRegularFile)
                    .map(Path::toString)
                    .collect(Collectors.toList());
        } catch (IOException e) {
            throw new RuntimeException("Failed to load metadata from local file system.", e);
        }
    }
}
