package com.xforceplus.ultraman.transfer.storage.mysql.api;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.domain.dto.AppInfo;
import com.xforceplus.ultraman.transfer.domain.dto.MetadataEntityDTO;
import com.xforceplus.ultraman.transfer.domain.dto.MetadataStr;
import com.xforceplus.ultraman.transfer.storage.api.IMetadataStorage;
import com.xforceplus.ultraman.transfer.domain.entity.MetadataEntity;
import com.xforceplus.ultraman.transfer.storage.mysql.repository.MetadataDbRepository;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/20 17:58
 * Description:
 * History:
 */
public class MysqlMetadataStorage implements IMetadataStorage {

    private MetadataDbRepository metadataDbRepository;

    public MysqlMetadataStorage(MetadataDbRepository metadataDbRepository) {
        this.metadataDbRepository = metadataDbRepository;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public AppInfo getLatestAppInfo(Long appId) {
        return metadataDbRepository.latestAppInfo(appId);
    }

//    @Override
//    public String getLatest(Long appId) {
//        return metadataDbRepository.latestVersion(appId);
//    }

    @Override
    public void saveMetadata(MetadataEntityDTO dto, String jsonStr) {
        MetadataEntity entity = dto.newEntity();
        entity.setContent(jsonStr);
        metadataDbRepository.insert(entity);
    }

    @Override
    public void saveMetadata(MetadataEntityDTO dto, Map<String, String> jsonStrMap) {
        for (String key : jsonStrMap.keySet()) {
            MetadataEntity newEntity = dto.newEntity();
            newEntity.setContent(jsonStrMap.get(key));
            metadataDbRepository.insert(newEntity);
        }
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, String jsonStr) {
        MetadataEntity metadataEntity = new MetadataEntity();
        metadataEntity.setAppId(appId);
        metadataEntity.setVersion(version);
        metadataEntity.setMetadataType(metadataType.code());
        metadataEntity.setContent(jsonStr);
        metadataDbRepository.insert(metadataEntity);
    }

    @Override
    public void saveMetadata(Long appId, String version, SchemaMetadataType metadataType, Map<String, String> jsonStrMap) {
        for (String key : jsonStrMap.keySet()) {
            MetadataEntity metadataEntity = new MetadataEntity();
            metadataEntity.setAppId(appId);
            metadataEntity.setMetadataId(Long.valueOf(key));
            metadataEntity.setVersion(version);
            metadataEntity.setMetadataType(metadataType.code());
            metadataEntity.setContent(jsonStrMap.get(key));
            metadataDbRepository.insert(metadataEntity);
        }
    }

    @Override
    public MetadataStr loadMetadataStr(Long appId, String version, SchemaMetadataType metadataType) {
        MetadataEntity metadataEntity = metadataDbRepository.get(appId, version, metadataType);
        return Optional.ofNullable(metadataEntity).map( x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setJsonContent(metadataEntity.getContent());
            metadataStr.setMetadataId(Optional.ofNullable(metadataEntity.getMetadataId())
                    .map(f -> f.toString()).orElse(null));
            return metadataStr;
        }).orElse(null);
    }

    @Override
    public List<MetadataStr> loadMetadataStrs(Long appId, String version, SchemaMetadataType metadataType) {
        List<String> collect = metadataDbRepository.list(appId, version, metadataType).stream().map(MetadataEntity::getContent).collect(Collectors.toList());
        return collect.stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setMetadataId(null);
            metadataStr.setJsonContent(x);
            return metadataStr;
        }).collect(Collectors.toList());
    }

    @Override
    public MetadataStr loadMetadataStr(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        MetadataEntity metadataEntity = metadataDbRepository.get(tenantAppId, tenantAppVersion, metadataType);
        return Optional.ofNullable(metadataEntity).map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setJsonContent(metadataEntity.getContent());
            metadataStr.setMetadataId(Optional.ofNullable(metadataEntity
                    .getMetadataId()).map(f -> f.toString()).orElse(null));
            return metadataStr;
        }).orElse(null);
    }

    @Override
    public List<MetadataStr> loadMetadataStrs(Long stdAppId, Long tenantAppId, String tenantCode, String tenantAppVersion, SchemaMetadataType metadataType) {
        List<String> collect = metadataDbRepository.list(tenantAppId, tenantAppVersion, metadataType).stream().map(MetadataEntity::getContent).collect(Collectors.toList());
        return collect.stream().map(x -> {
            MetadataStr metadataStr = new MetadataStr();
            metadataStr.setMetadataId(null);
            metadataStr.setJsonContent(x);
            return metadataStr;
        }).collect(Collectors.toList());
    }
}
