package com.xforceplus.ultraman.transfer.storage.mysql.repository;

import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.transfer.common.util.JsonUtils;
import com.xforceplus.ultraman.transfer.domain.dto.AppInfo;
import com.xforceplus.ultraman.transfer.domain.entity.MetadataEntity;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import org.checkerframework.checker.units.qual.A;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/21 17:08
 * Description:
 * History:
 */
public class MetadataDbRepository {

    private static final String METADATA_TABLE = "metadata";

    private JdbcTemplate jdbcTemplate;

    private SimpleJdbcInsert simpleJdbcInsert;

    public MetadataDbRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.simpleJdbcInsert = new SimpleJdbcInsert(jdbcTemplate).withTableName(METADATA_TABLE).usingGeneratedKeyColumns("ID");
    }

    public void insert(MetadataEntity entity){
        entity.setCreateTime(LocalDateTime.now());
        entity.setUpdateTime(LocalDateTime.now());
        simpleJdbcInsert.executeAndReturnKey(new BeanPropertySqlParameterSource(entity));
    }

    public List<MetadataEntity> list(Long appId, String version) {
        String sql = "SELECT * FROM METADATA WHERE APP_ID = ? and VERSION = ?";
        return jdbcTemplate.query(
                sql, new MetadataRowMapper(), new Object[] { appId, version });
    }

    public MetadataEntity get(Long appId, String version, SchemaMetadataType metadataType) {
        String sql = "SELECT * FROM METADATA WHERE APP_ID = ? and VERSION = ? and METADATA_TYPE = ?";
        List<MetadataEntity> list
                = jdbcTemplate.query(sql, new MetadataRowMapper(), new Object[] { appId, version, metadataType.code() });
        return list.isEmpty() ? null : list.get(0);
    }

    public List<MetadataEntity> list(Long appId, String version, SchemaMetadataType metadataType) {
        String sql = "SELECT * FROM METADATA WHERE APP_ID = ? and VERSION = ? and METADATA_TYPE = ?";
        return jdbcTemplate.query(sql, new MetadataRowMapper(), new Object[] { appId, version, metadataType.code() });
    }
    
//    public String latestVersion(Long appId) {
//        String sql = "SELECT VERSION FROM METADATA WHERE APP_ID = ? ORDER BY CREATE_TIME DESC LIMIT 1";
//        return jdbcTemplate.queryForObject(sql, String.class, appId);
//    }

    public AppInfo latestAppInfo(Long appId) {
        String sql = "SELECT CONTENT FROM METADATA WHERE APP_ID = ? AND METADATA_TYPE = 'app' ORDER BY CREATE_TIME DESC LIMIT 1";
        TransferMessage message = jdbcTemplate.queryForObject(sql, new RowMapper<TransferMessage>() {

            @Override
            public TransferMessage mapRow(ResultSet rs, int rowNum) throws SQLException {
                String string = rs.getString(1);
                TransferMessage transferMessage = JsonUtils.json2Object(string, TransferMessage.class);
                if(transferMessage != null ) {
                    return transferMessage;
                } else {
                    return null;
                }
            }
        }, appId);
        
        if(message != null) {
            AppInfo appInfo = new AppInfo();
            appInfo.setAppCode(message.getAppCode());
            appInfo.setAppId(message.getAppId());
            appInfo.setAppCodeForDb(message.getAppCodeForDB());
            appInfo.setVersion(message.getVersion());
            return appInfo;
        } else {
           throw new RuntimeException("AppVersion is Missing");
        }
    }

//    public int[] batchUpdateUsingJdbcTemplate(List<MetadataEntity> entities) {
//        return jdbcTemplate.batchUpdate("INSERT INTO METADATA VALUES (?, ?, ?, ?)",
//                new BatchPreparedStatementSetter() {
//                    @Override
//                    public void setValues(PreparedStatement ps, int i) throws SQLException {
//                        ps.setLong(1, entities.get(i).getId());
//                        ps.setLong(2, entities.get(i).getAppId());
//                        ps.setString(3, entities.get(i).getVersion());
//                        ps.setInt(4, entities.get(i).getVersionNumber());
//                        ps.setString(5, entities.get(i).getMetadataType());
//                        ps.setString(6, entities.get(i).getContent());
//                        ps.setDate(7, entities.get(i).getCreateTime().toLocalDate());
//                        ps.set(8, entities.get(i).getUpdateTime());
//                    }
//                    @Override
//                    public int getBatchSize() {
//                        return 50;
//                    }
//                });
//    }
}
