package com.xforceplus.ultraman.transfer.storage.mysql.repository;

import com.xforceplus.ultraman.transfer.domain.entity.MetadataEntity;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/21 17:15
 * Description:
 * History:
 */
public class MetadataRowMapper implements RowMapper<MetadataEntity> {
    @Override
    public MetadataEntity mapRow(ResultSet rs, int rowNum) throws SQLException {
        MetadataEntity entity = new MetadataEntity();
        entity.setId(rs.getLong("id"));
        entity.setAppId(rs.getLong("app_id"));
        entity.setMetadataId(rs.getLong("metadata_id"));
        entity.setMetadataType(rs.getString("metadata_type"));
        entity.setVersion(rs.getString("version"));
        entity.setVersionNumber(rs.getInt("version_number"));
        entity.setContent(rs.getString("content"));
        entity.setTenantCode(rs.getString("tenant_code"));
        entity.setCreateTime(rs.getObject("create_time", LocalDateTime.class));
        entity.setUpdateTime(rs.getObject("update_time", LocalDateTime.class));
        return entity;
    }
}
