create table metadata
(
    id             bigint auto_increment        primary key,
    app_id         bigint                       null comment '应用ID',
    is_deploy      tinyint(1) default 0         null comment '是否部署',
    metadata_id    bigint                       null comment '元数据ID',
    metadata_type  varchar(16) collate utf8_bin null comment '元数据类型包括实体，字典等',
    content        longtext collate utf8_bin    null comment '元数据配置json结构',
    version        varchar(64) collate utf8_bin null comment '版本',
    version_number int                          null comment '版本数',
    tenant_id      bigint                       null comment '租户ID',
    tenant_code    varchar(180)                 null comment '租户代码',
    tenant_name    varchar(180)                 null comment '租户名称',
    profile        varchar(180)                 null comment 'Profile',
    create_time    datetime                     null comment '创建时间',
    update_time    datetime                     null comment '更新时间',
    constraint IUX_T1
        unique (app_id, metadata_type, version, metadata_id)
) comment '部署元数据' charset = utf8mb4;