package com.xforceplus.ultraman.bpm.agent.delegate;

import com.xforceplus.ultraman.bpm.agent.config.AgentConfig;
import com.xforceplus.ultraman.bpm.agent.model.AgentClient;
import com.xforceplus.ultraman.bpm.utils.rest.Restty;
import com.xplat.ultraman.api.management.commons.enums.Method;
import com.xplat.ultraman.api.management.commons.enums.Protocol;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;

import static com.xforceplus.ultraman.bpm.agent.utils.UrlUtils.replace;
import static com.xforceplus.ultraman.bpm.exception.utils.ObjectMapperUtils.object2Json;


/**
 * desc :
 * name : IHttpMethod
 *
 * @author : xujia
 * date : 2020/4/22
 * @since : 1.8
 */
public interface IMethod {
    static Logger logger = LoggerFactory.getLogger("IMethod");

    Object execute(AgentClient<?> agentClient, AgentConfig agentConfig) throws IOException;

    default Restty createRestClient(AgentClient<?> agentClient, AgentConfig agentConfig) throws IOException {
        replacePathVariables(agentClient);

        String finalUrl = getFinalUrl(agentClient, getProtocol(agentClient.getProtocol()));

        Restty restty = Restty.create(finalUrl, agentConfig.getConnectTimeOut(),
                agentConfig.getReadTimeOut(), agentConfig.getWriteTimeOut(), agentConfig.getRetries());

        if (null != agentClient.getHeaders()) {
            restty.setHeaders(agentClient.getHeaders());
        }

        if (null != agentClient.getParameters()) {
            restty.addAllParameters(agentClient.getParameters());
        }

        return restty;
    }

    default void setBodyWithType(Restty restty, String bodyType, Object body) {
        restty.addMediaType(bodyType);
        restty.requestBody(body);
    }

    default void replacePathVariables(AgentClient<?> agentClient) {
        Map<String, String> pathVariables = agentClient.getPathVariables();
        if (null != pathVariables && StringUtils.isNotBlank(agentClient.getUrl())) {
            pathVariables.forEach(
                    (k, v) -> {
                        agentClient.setUrl(replace(agentClient.getUrl(), k, v));
                    }
            );
        }
    }

    default String getProtocol(Protocol protocol) {
        return (protocol == null) ? Protocol.HTTP.getValue() : protocol.getValue();
    }

    default String getFinalUrl(AgentClient<?> agentClient, String protocol) {
        String finalUrl = agentClient.getHost() + agentClient.getUrl();
        if (!agentClient.getHost().startsWith("http")) {
            finalUrl = protocol + finalUrl;
        }
        return finalUrl;
    }

    default void printRequest(Restty restty, Object bodyObject, Method method) {
        try {
            logger.info("发送{}请求, url : {}, headers : {}, requestBody : {}",
                    method.name(), restty.getUrl(),
                    null != restty.getHeaders() ? object2Json(restty.getHeaders()) : "null",
                    null != bodyObject ? object2Json(bodyObject) : "null");
        } catch (Exception e) {
            // ignore
        }
    }
}
