package com.xforceplus.ultraman.bpm.agent.handler;


import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bpm.agent.config.AgentConfig;
import com.xforceplus.ultraman.bpm.agent.delegate.*;
import com.xforceplus.ultraman.bpm.agent.exception.AgentException;
import com.xforceplus.ultraman.bpm.agent.model.AgentClient;
import com.xplat.ultraman.api.management.commons.enums.Method;
import lombok.Data;

import java.io.IOException;
import java.util.Map;

import static com.xforceplus.ultraman.bpm.agent.exception.AgentErrorCode.*;
import static com.xplat.ultraman.api.management.commons.enums.Method.*;


/**
 * desc :
 * name : AgentHandler
 *
 * @author : xujia
 * date : 2020/4/22
 * @since : 1.8
 */
@Data
public class AgentHandler {

    private static final Map<Method, IMethod> agentMaps = Maps.newHashMap();

    static {
        initAgentMaps();
    }

    private static void initAgentMaps() {
        agentMaps.put(GET, new Get());
        agentMaps.put(POST, new Post());
        agentMaps.put(PUT, new Put());
        agentMaps.put(DELETE, new Delete());
    }

    public static Map<Method, IMethod> getAgentMaps() {
        return agentMaps;
    }

    public static Object execute(AgentClient<?> agentClient, AgentConfig agentConfig) {
        if (null == agentClient) {
            throw new AgentException(AGENT_CLIENT_NOT_NULL.status, "agentClient不能为空.");
        }
        IMethod httpMethod = agentMaps.get(agentClient.getHttpMethod());
        if (null == httpMethod) {
            throw new AgentException(UN_SUPPORT_METHOD.status, "不支持的请求方式 : " + agentClient.getHttpMethod());
        }

        try {
            return httpMethod.execute(agentClient, null == agentConfig ? new AgentConfig() : agentConfig);
        } catch (IOException ex) {
            throw new AgentException(AGENT_CALL_EXTERNAL_ERROR.status, ex.getMessage());
        }
    }
}
