package com.xforceplus.ultraman.bpm.agent.model;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bpm.utils.rest.ParameterTypeReference;
import com.xplat.ultraman.api.management.commons.enums.Method;
import com.xplat.ultraman.api.management.commons.enums.Protocol;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * desc :
 * name : AgentClient
 *
 * @param <R>
 * @author : xujia
 * date : 2020/4/22
 * @since : 1.8
 */
@Data
public class AgentClient<R> implements Serializable {
    private String host;
    private String url;
    private Method httpMethod;
    private Protocol protocol;
    private Map<String, String> headers;
    private Map<String, String> parameters;
    private Map<String, String> pathVariables;
    private Object body;
    private ParameterTypeReference<R> parameterTypeReference;

    public AgentClient(AgentClientBuilder<R> agentClientBuilder) {
        this.host = agentClientBuilder.getHost();
        this.url = agentClientBuilder.getUrl();
        this.httpMethod = agentClientBuilder.getHttpMethod();
        this.protocol = agentClientBuilder.getProtocol();
        this.headers = agentClientBuilder.getHeaders();
        this.parameters = agentClientBuilder.getParameters();
        this.pathVariables = agentClientBuilder.getPathVariables();
        this.body = agentClientBuilder.getBody();
        if (null != agentClientBuilder.getParameterTypeReference()) {
            this.parameterTypeReference = agentClientBuilder.getParameterTypeReference();
        }
    }

    /**
     * desc :
     * name : AgentClientBuilder
     *
     * @param <R>
     * @author : xujia
     * date : 2020/4/22
     * @since : 1.8
     */
    @Data
    public static class AgentClientBuilder<R> {
        private String host;
        private String url;
        private Method httpMethod;
        private Protocol protocol;
        private Map<String, String> headers;
        private Map<String, String> parameters;
        private Map<String, String> pathVariables;
        private Object body;
        private ParameterTypeReference<R> parameterTypeReference;

        public AgentClientBuilder(String host, String url) {
            this.host = host;
            this.url = url;
        }

        public AgentClientBuilder<R> method(Method httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public AgentClientBuilder<R> protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }


        public AgentClientBuilder<R> headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public AgentClientBuilder<R> header(String key, String value) {
            if (null == this.headers) {
                this.headers = Maps.newHashMap();
            }
            this.headers.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> pathVariables(Map<String, String> pathVariables) {
            this.pathVariables = pathVariables;
            return this;
        }

        public AgentClientBuilder<R> pathVariables(String key, String value) {
            if (null == this.pathVariables) {
                this.pathVariables = Maps.newHashMap();
            }
            this.pathVariables.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public AgentClientBuilder<R> parameters(String key, String value) {
            if (null == this.parameters) {
                this.parameters = Maps.newHashMap();
            }
            this.parameters.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> body(Object body) {
            this.body = body;
            return this;
        }

        public AgentClientBuilder<R> parameterTypeReference(ParameterTypeReference<R> parameterTypeReference) {
            this.parameterTypeReference = parameterTypeReference;
            return this;
        }

        public AgentClient<R> builder() {
            return new AgentClient<R>(this);
        }
    }
}
