/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bpm.agent.delegate;

import com.xforceplus.ultraman.bpm.agent.config.AgentConfig;
import com.xforceplus.ultraman.bpm.agent.model.AgentClient;
import com.xforceplus.ultraman.bpm.agent.utils.UrlUtils;
import com.xforceplus.ultraman.bpm.exception.utils.ObjectMapperUtils;
import com.xforceplus.ultraman.bpm.utils.rest.Restty;
import com.xplat.ultraman.api.management.commons.enums.Method;
import com.xplat.ultraman.api.management.commons.enums.Protocol;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IMethod {
    public static final Logger logger = LoggerFactory.getLogger((String)"IMethod");

    public Object execute(AgentClient<?> var1, AgentConfig var2) throws IOException;

    default public Restty createRestClient(AgentClient<?> agentClient, AgentConfig agentConfig) throws IOException {
        this.replacePathVariables(agentClient);
        String finalUrl = this.getFinalUrl(agentClient, this.getProtocol(agentClient.getProtocol()));
        Restty restty = Restty.create((String)finalUrl, (long)agentConfig.getConnectTimeOut(), (long)agentConfig.getReadTimeOut(), (long)agentConfig.getWriteTimeOut(), (int)agentConfig.getRetries());
        if (null != agentClient.getHeaders()) {
            restty.setHeaders(agentClient.getHeaders());
        }
        if (null != agentClient.getParameters()) {
            restty.addAllParameters(agentClient.getParameters());
        }
        return restty;
    }

    default public void setBodyWithType(Restty restty, String bodyType, Object body) {
        restty.addMediaType(bodyType);
        restty.requestBody(body);
    }

    default public void replacePathVariables(AgentClient<?> agentClient) {
        Map<String, String> pathVariables = agentClient.getPathVariables();
        if (null != pathVariables && StringUtils.isNotBlank((CharSequence)agentClient.getUrl())) {
            pathVariables.forEach((k, v) -> agentClient.setUrl(UrlUtils.replace(agentClient.getUrl(), k, v)));
        }
    }

    default public String getProtocol(Protocol protocol) {
        return protocol == null ? Protocol.HTTP.getValue() : protocol.getValue();
    }

    default public String getFinalUrl(AgentClient<?> agentClient, String protocol) {
        String finalUrl = agentClient.getHost() + agentClient.getUrl();
        if (!agentClient.getHost().startsWith("http")) {
            finalUrl = protocol + finalUrl;
        }
        return finalUrl;
    }

    default public void printRequest(Restty restty, Object bodyObject, Method method) {
        try {
            logger.info("\u53d1\u9001{}\u8bf7\u6c42, url : {}, headers : {}, requestBody : {}", new Object[]{method.name(), restty.getUrl(), null != restty.getHeaders() ? ObjectMapperUtils.object2Json((Object)restty.getHeaders()) : "null", null != bodyObject ? ObjectMapperUtils.object2Json((Object)bodyObject) : "null"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

