/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bpm.agent.handler;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bpm.agent.config.AgentConfig;
import com.xforceplus.ultraman.bpm.agent.delegate.Delete;
import com.xforceplus.ultraman.bpm.agent.delegate.Get;
import com.xforceplus.ultraman.bpm.agent.delegate.IMethod;
import com.xforceplus.ultraman.bpm.agent.delegate.Post;
import com.xforceplus.ultraman.bpm.agent.delegate.Put;
import com.xforceplus.ultraman.bpm.agent.exception.AgentErrorCode;
import com.xforceplus.ultraman.bpm.agent.exception.AgentException;
import com.xforceplus.ultraman.bpm.agent.model.AgentClient;
import com.xplat.ultraman.api.management.commons.enums.Method;
import java.io.IOException;
import java.util.Map;

public class AgentHandler {
    private static final Map<Method, IMethod> agentMaps = Maps.newHashMap();

    private static void initAgentMaps() {
        agentMaps.put(Method.GET, new Get());
        agentMaps.put(Method.POST, new Post());
        agentMaps.put(Method.PUT, new Put());
        agentMaps.put(Method.DELETE, new Delete());
    }

    public static Map<Method, IMethod> getAgentMaps() {
        return agentMaps;
    }

    public static Object execute(AgentClient<?> agentClient, AgentConfig agentConfig) {
        if (null == agentClient) {
            throw new AgentException(AgentErrorCode.AGENT_CLIENT_NOT_NULL.status, "agentClient\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        IMethod httpMethod = agentMaps.get(agentClient.getHttpMethod());
        if (null == httpMethod) {
            throw new AgentException(AgentErrorCode.UN_SUPPORT_METHOD.status, "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f : " + agentClient.getHttpMethod());
        }
        try {
            return httpMethod.execute(agentClient, null == agentConfig ? new AgentConfig() : agentConfig);
        }
        catch (IOException ex) {
            throw new AgentException(AgentErrorCode.AGENT_CALL_EXTERNAL_ERROR.status, ex.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentHandler)) {
            return false;
        }
        AgentHandler other = (AgentHandler)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentHandler;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "AgentHandler()";
    }

    static {
        AgentHandler.initAgentMaps();
    }
}

