/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.processor.impl;

import com.xforceplus.ultraman.cdc.processor.EventQueue;
import com.xforceplus.ultraman.cdc.processor.OnceCompletableFuture;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.sdk.infra.base.cdc.SystemAttachment;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultEventQueue
implements EventQueue {
    private Map<String, List<OqsEngineEntity>> createMapping = new ConcurrentHashMap<String, List<OqsEngineEntity>>();
    private Map<String, OnceCompletableFuture<OqsEngineEntity>> createFutureMap = new ConcurrentHashMap<String, OnceCompletableFuture<OqsEngineEntity>>();
    private Map<String, List<Tuple2<OqsEngineEntity, OqsEngineEntity>>> updateMapping = new ConcurrentHashMap<String, List<Tuple2<OqsEngineEntity, OqsEngineEntity>>>();
    private Map<String, OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>>> updateFutureMap = new ConcurrentHashMap<String, OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>>>();
    private Map<String, List<OqsEngineEntity>> deleteMapping = new ConcurrentHashMap<String, List<OqsEngineEntity>>();
    private Map<String, OnceCompletableFuture<OqsEngineEntity>> deleteFutureMap = new ConcurrentHashMap<String, OnceCompletableFuture<OqsEngineEntity>>();

    private OqsEngineEntity merge(OqsEngineEntity before, OqsEngineEntity after) {
        before.getAttributes().putAll(after.getAttributes());
        if (after.isDeleted()) {
            before.setDeleted(true);
        }
        if (after.getFather() > 0L && before.getFather() == 0L) {
            before.setFather(after.getFather());
        }
        before.setUpdateTime(after.getUpdateTime());
        return before;
    }

    @Override
    public OnceCompletableFuture<OqsEngineEntity> feedCreate(SystemAttachment attachment, OqsEngineEntity after) {
        if (attachment.getGrouped() > 1) {
            long id = after.getId();
            String key = Long.toString(id);
            List oqsEngineEntities = this.createMapping.computeIfAbsent(key, k -> new ArrayList());
            if (oqsEngineEntities.size() + 1 == attachment.getGrouped()) {
                oqsEngineEntities.add(after);
                Optional reduce = oqsEngineEntities.stream().reduce((a, b) -> this.merge((OqsEngineEntity)a, (OqsEngineEntity)b));
                OqsEngineEntity oqsEngineEntity = reduce.orElse(after);
                OnceCompletableFuture<OqsEngineEntity> futureO = this.createFutureMap.get(key);
                futureO.complete(oqsEngineEntity);
                this.createFutureMap.remove(key);
                this.createMapping.remove(key);
            } else {
                oqsEngineEntities.add(after);
            }
            return this.createFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture());
        }
        OnceCompletableFuture<OqsEngineEntity> future = new OnceCompletableFuture<OqsEngineEntity>();
        future.complete(after);
        return future;
    }

    @Override
    public OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> feedUpdate(SystemAttachment attachment, OqsEngineEntity before, OqsEngineEntity after) {
        Tuple2 input = Tuple.of((Object)before, (Object)after);
        if (attachment.getGrouped() > 1) {
            long id = before.getId();
            int version = before.getVersion();
            String key = Long.toString(id).concat(":").concat(Integer.toString(version));
            List tuple2s = this.updateMapping.computeIfAbsent(key, k -> new ArrayList());
            if (tuple2s.size() + 1 == attachment.getGrouped()) {
                tuple2s.add(Tuple.of((Object)before, (Object)after));
                Optional reduce = tuple2s.stream().reduce((t1, t2) -> Tuple.of((Object)this.merge((OqsEngineEntity)t1._1, (OqsEngineEntity)t2._1), (Object)this.merge((OqsEngineEntity)t1._2, (OqsEngineEntity)t2._2)));
                Tuple2 result = reduce.orElse(input);
                OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> futureO = this.updateFutureMap.get(key);
                futureO.complete((Tuple2<OqsEngineEntity, OqsEngineEntity>)result);
                this.updateFutureMap.remove(key);
                this.updateMapping.remove(key);
            } else {
                tuple2s.add(input);
            }
            return this.updateFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture());
        }
        OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> future = new OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>>();
        future.complete(input);
        return future;
    }

    @Override
    public OnceCompletableFuture<OqsEngineEntity> feedDelete(SystemAttachment attachment, OqsEngineEntity before) {
        if (attachment.getGrouped() > 1) {
            long id = before.getId();
            String key = Long.toString(id);
            List oqsEngineEntities = this.deleteMapping.computeIfAbsent(key, k -> new ArrayList());
            if (oqsEngineEntities.size() + 1 == attachment.getGrouped()) {
                oqsEngineEntities.add(before);
                Optional reduce = oqsEngineEntities.stream().reduce((a, b) -> this.merge((OqsEngineEntity)a, (OqsEngineEntity)b));
                OqsEngineEntity oqsEngineEntity = reduce.orElse(before);
                OnceCompletableFuture<OqsEngineEntity> futureO = this.deleteFutureMap.get(key);
                futureO.complete(oqsEngineEntity);
                this.deleteFutureMap.remove(key);
                this.deleteMapping.remove(key);
            } else {
                oqsEngineEntities.add(before);
            }
            return this.deleteFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture());
        }
        OnceCompletableFuture<OqsEngineEntity> future = new OnceCompletableFuture<OqsEngineEntity>();
        future.complete(before);
        return future;
    }
}

