package com.xforceplus.ultraman.cdc.utils;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.CanalEntry.Column;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

/**
 * mysql bin log 解析工具.
 *
 * @author xujia 2020/11/11
 * @since : 1.8
 */
public class BinLogParseUtils {

  /**
   * 获取长整形数值型字段值，当异常时返回默认值.
   */

  public static long getLongFromColumn(Map<String, Column> columns, String code,
      Long defaultValue) {
    try {
      Long value = getLongFromColumn(columns, code);
      if (null == value) {
        return defaultValue;
      }
      return value;
    } catch (Exception e) {
      return defaultValue;
    }
  }

  /**
   * 获取整形数值字段值，当异常时返回默认值.
   */
  public static int getIntegerFromColumn(Map<String, Column> columns, String code,
      Integer defaultValue) {
    try {
      Integer value = getIntegerFromColumn(columns, code);
      if (null == value) {
        return defaultValue;
      }
      return value;
    } catch (Exception e) {
      return defaultValue;
    }
  }


  /**
   * 获取整形数值字段值，抛出异常.
   */
  public static long getLongFromColumn(Map<String, Column> columns, String code) throws SQLException {

    CanalEntry.Column column = getColumnWithoutNull(columns, code);

    if (null == column) {
      throw new SQLException(String.format("%s could not be null.", code));
    }

    return Long.parseLong(column.getValue());
  }

  /**
   * 获取整形数值字段值，抛出异常.
   */
  public static long getLongFromColumn(List<Column> columns, String code) throws SQLException {

    CanalEntry.Column column = getColumnWithoutNull(columns, code);

    if (null == column) {
      throw new SQLException(String.format("%s could not be null.", code));
    }

    return Long.parseLong(column.getValue());
  }

  /**
   * 获取整形数值字段值，抛出异常.
   */
  public static Integer getIntegerFromColumn(Map<String, Column> columns, String code) throws SQLException {

    CanalEntry.Column column = getColumnWithoutNull(columns, code);

    if (null == column) {
      throw new SQLException(String.format("%s could not be null.", code));
    }

    return Integer.parseInt(column.getValue());
  }

  public static String getStringFromColumn(Map<String, Column> columns, String code) {
    CanalEntry.Column column = getColumnWithoutNull(columns, code);
    if (null == column) {
      return "";
    }
    return column.getValue();
  }

  /**
   * 获取bool类型字段值.
   */
  public static Boolean getBooleanFromColumn(Map<String, Column> columns, String code) {
    CanalEntry.Column column = getColumnWithoutNull(columns, code);
    if (null == column) {
      return null;
    }
    return stringToBoolean(column.getValue());
  }

  /**
   * 转换字符串为布尔.
   */
  public static boolean stringToBoolean(String str) {
    return str.equalsIgnoreCase("true")
        || (StringUtils.isNumeric(str) && Integer.parseInt(str) > 0);
  }

  /**
   * 获取字段表示.
   */
  public static CanalEntry.Column getColumnWithoutNull(Map<String, Column> columns, String code) {
    return columns.containsKey(code) ? columns.get(code) : null;
  }

  public static CanalEntry.Column getColumnWithoutNull(List<Column> columns, String code) {
    Optional<Column> first = columns.stream().filter(column -> {
      if (StringUtils.equalsIgnoreCase(column.getName(), code)) {
        return true;
      }
      return false;
    }).findFirst();
    return first.isPresent() == true ? first.get() : null;
  }
}
