package com.xforceplus.ultraman.cdc.processor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class OnceCompletableFuture<T> {

    private CompletableFuture<T> completableFuture;

    private boolean isSetConsumer = false;

    public OnceCompletableFuture() {
        this.completableFuture = new CompletableFuture<>();
    }

    public void complete(T t) {
        this.completableFuture.complete(t);
    }

    synchronized public void thenAcceptOnce(Consumer<T> consumer, ExecutorService service) {
        if (!this.isSetConsumer) {
            this.isSetConsumer = true;
            completableFuture.thenAcceptAsync(consumer, service);
        }
    }
}
