package com.xforceplus.ultraman.cdc.core.remote.connect;


import com.alibaba.otter.canal.protocol.Message;
import com.xforceplus.ultraman.cdc.CDCLifeCycle;
import java.sql.SQLException;


/**
 * CDC 连接器抽像实现.
 *
 * @author xujia 2020/11/5
 * @since 1.8
 */
public interface CDCConnector extends CDCLifeCycle {

    int MAX_RECONNECT_TIMES_PER_CONNECTIONS = 10;

    default boolean isMaxRetry(int times) {
        return times >= MAX_RECONNECT_TIMES_PER_CONNECTIONS;
    }

    /**
     * 打开canal连接.
     */
    void open();

    /**
     * 无条件关闭canal连接.
     */
    void close();

    /**
     * 回滚.
     */
    void rollback();

    /**
     * 回应.
     */
    void ack(long batchId) throws SQLException;

    /**
     * 不自动确认获取消息.
     *
     * @return 消息实例.
     * @throws SQLException 获取发生异常.
     */
   Message getMessageWithoutAck() throws SQLException;


   int getBatchSize();

   String name();
}
