package com.xforceplus.ultraman.cdc.processor.impl;

import com.xforceplus.ultraman.cdc.processor.EventQueue;
import com.xforceplus.ultraman.cdc.processor.OnceCompletableFuture;
import com.xforceplus.ultraman.cdc.processor.SystemAttachment;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import io.vavr.Tuple;
import io.vavr.Tuple2;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultEventQueue implements EventQueue {

    private Map<String, List<OqsEngineEntity>> createMapping = new ConcurrentHashMap<>();

    private Map<String, OnceCompletableFuture<OqsEngineEntity>> createFutureMap = new ConcurrentHashMap<>();

    private Map<String, List<Tuple2<OqsEngineEntity, OqsEngineEntity>>> updateMapping = new ConcurrentHashMap<>();

    private Map<String, OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>>> updateFutureMap = new ConcurrentHashMap<>();

    private Map<String, List<OqsEngineEntity>> deleteMapping = new ConcurrentHashMap<>();

    private Map<String, OnceCompletableFuture<OqsEngineEntity>> deleteFutureMap = new ConcurrentHashMap<>();

    private OqsEngineEntity merge(OqsEngineEntity before, OqsEngineEntity after) {
        before.getAttributes().putAll(after.getAttributes());

        if (after.isDeleted()) {
            before.setDeleted(true);
        }

        if (after.getFather() > 0 && before.getFather() == 0) {
            before.setFather(after.getFather());
        }

        before.setUpdateTime(after.getUpdateTime());
        return before;
    }

    @Override
    public OnceCompletableFuture<OqsEngineEntity> feedCreate(SystemAttachment attachment, OqsEngineEntity after) {

        if(attachment.getGrouped() > 1) {
            long id = after.getId();
            String key = Long.toString(id);
            List<OqsEngineEntity> oqsEngineEntities = createMapping.computeIfAbsent(key, k -> new ArrayList<>());

            if(oqsEngineEntities.size() + 1 == attachment.getGrouped()) {
                //emmit all
                oqsEngineEntities.add(after);

                Optional<OqsEngineEntity> reduce = oqsEngineEntities.stream().reduce((a, b) -> merge(a, b));
                OqsEngineEntity oqsEngineEntity = reduce.orElse(after);
                OnceCompletableFuture<OqsEngineEntity> futureO = createFutureMap.get(key);
                futureO.complete(oqsEngineEntity);
                /**
                 * clean
                 */
                createFutureMap.remove(key);
                createMapping.remove(key);
            } else {
                oqsEngineEntities.add(after);
            }

            return createFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture<>());
        } else {
            OnceCompletableFuture<OqsEngineEntity> future = new OnceCompletableFuture<>();
            future.complete(after);
            return future;
        }
    }

    @Override
    public OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> feedUpdate(SystemAttachment attachment, OqsEngineEntity before, OqsEngineEntity after) {

        Tuple2<OqsEngineEntity, OqsEngineEntity> input = Tuple.of(before, after);
        if(attachment.getGrouped() > 1) {
            long id = before.getId();
            int version = before.getVersion();
            String key = Long.toString(id).concat(":").concat(Integer.toString(version));
            List<Tuple2<OqsEngineEntity, OqsEngineEntity>> tuple2s = updateMapping.computeIfAbsent(key, k -> new ArrayList<>());
            if(tuple2s.size() + 1 == attachment.getGrouped()) {
                tuple2s.add(Tuple.of(before, after));
                Optional<Tuple2<OqsEngineEntity, OqsEngineEntity>> reduce = tuple2s.stream().reduce((t1, t2) -> {
                    return Tuple.of(merge(t1._1, t2._1), merge(t1._2, t2._2));
                });

                Tuple2<OqsEngineEntity, OqsEngineEntity> result = reduce.orElse(input);
                OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> futureO = updateFutureMap.get(key);
                futureO.complete(result);
                updateFutureMap.remove(key);
                updateMapping.remove(key);
            } else {
                tuple2s.add(input);
            }
            return updateFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture<>());
        } else {
            OnceCompletableFuture<Tuple2<OqsEngineEntity, OqsEngineEntity>> future = new OnceCompletableFuture<>();
            future.complete(input);
            return future;
        }
    }

    @Override
    public OnceCompletableFuture<OqsEngineEntity> feedDelete(SystemAttachment attachment, OqsEngineEntity before) {

        if(attachment.getGrouped() > 1) {
            long id = before.getId();
            String key = Long.toString(id);
            List<OqsEngineEntity> oqsEngineEntities = deleteMapping.computeIfAbsent(key, k -> new ArrayList<>());

            if(oqsEngineEntities.size() + 1 == attachment.getGrouped()) {
                //emmit all
                oqsEngineEntities.add(before);

                Optional<OqsEngineEntity> reduce = oqsEngineEntities.stream().reduce((a, b) -> merge(a, b));
                OqsEngineEntity oqsEngineEntity = reduce.orElse(before);
                OnceCompletableFuture<OqsEngineEntity> futureO = deleteFutureMap.get(key);
                futureO.complete(oqsEngineEntity);
                deleteFutureMap.remove(key);
                deleteMapping.remove(key);
            } else {
                oqsEngineEntities.add(before);
            }

            return deleteFutureMap.computeIfAbsent(key, k -> new OnceCompletableFuture<>());
        } else {
            OnceCompletableFuture<OqsEngineEntity> future = new OnceCompletableFuture<>();
            future.complete(before);
            return future;
        }
    }
}
