/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.reader;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xforceplus.ultraman.cdc.reader.CDCConfigResolver;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackageInternal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderFactory {
    private static Logger logger = LoggerFactory.getLogger(ReaderFactory.class);

    public static CDCPropertyPackage build(CDCConfigResolver resolver, String[] activeProfiles) {
        String activeProfile;
        String baseName = "oqs-cdc";
        Config baseConfig = ConfigFactory.load((String)baseName);
        Config config = null;
        if (activeProfiles.length > 0 && !(activeProfile = activeProfiles[0]).equalsIgnoreCase("DEFAULT") && !StringUtils.isEmpty((CharSequence)activeProfile)) {
            try {
                Config extend = ConfigFactory.load((String)baseName.concat("-").concat(activeProfile));
                config = extend.withFallback((ConfigMergeable)baseConfig).resolve();
            }
            catch (Throwable throwable) {
                logger.warn("Cannot find related {}", (Object)activeProfile);
            }
        }
        if (config == null) {
            config = baseConfig;
        }
        CDCPropertyPackageInternal result = resolver.resolve(config);
        return new CDCPropertyPackage(result);
    }
}

