/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.processor.impl;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.protobuf.ByteString;
import com.xforceplus.ultraman.cdc.context.ParserContext;
import com.xforceplus.ultraman.cdc.utils.BinLogParseUtils;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParseMessageToRowData {
    private static final Logger log = LoggerFactory.getLogger(ParseMessageToRowData.class);
    private EntityClassEngine engine;

    public ParseMessageToRowData(EntityClassEngine engine) {
        this.engine = engine;
    }

    public Map<CanalEntry.EventType, Map<String, Map<Long, OqsEngineEntity>>> parseCanalEntries(List<CanalEntry.Entry> entries, ParserContext parserContext) throws SQLException {
        HashMap<CanalEntry.EventType, Map<String, Map<Long, OqsEngineEntity>>> binlogRowDataMap = new HashMap<CanalEntry.EventType, Map<String, Map<Long, OqsEngineEntity>>>();
        for (CanalEntry.Entry entry : entries) {
            switch (entry.getEntryType()) {
                case TRANSACTIONBEGIN: 
                case TRANSACTIONEND: {
                    this.eventHandler(entry.getEntryType());
                    break;
                }
                case ROWDATA: {
                    this.rowDataParse(entry, parserContext, binlogRowDataMap);
                    break;
                }
            }
        }
        return binlogRowDataMap;
    }

    private void eventHandler(CanalEntry.EntryType entryType) {
    }

    private void rowDataParse(CanalEntry.Entry entry, ParserContext parserContext, Map<CanalEntry.EventType, Map<String, Map<Long, OqsEngineEntity>>> binlogRowDataMap) throws SQLException {
        String tableName = entry.getHeader().getTableName();
        if (tableName.isEmpty()) {
            log.error("batch : {}, table name could not be Null, [{}]", (Object)parserContext.getBatchId(), (Object)entry.getStoreValue());
            return;
        }
        Optional<IEntityClass> entityClassOp = this.foundEntityClassFromTableName(tableName);
        IEntityClass iEntityClass = entityClassOp.get();
        if (!entityClassOp.isPresent()) {
            log.error("batch : {}, entityClass could not be Null, [{}]", (Object)parserContext.getBatchId(), (Object)tableName);
            return;
        }
        try {
            CanalEntry.RowChange rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
            CanalEntry.EventType eventType = rowChange.getEventType();
            for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                HashMap<String, CanalEntry.Column> beforeColumnsMap = new HashMap<String, CanalEntry.Column>();
                rowData.getBeforeColumnsList().stream().forEach(column -> beforeColumnsMap.put(column.getName(), (CanalEntry.Column)column));
                HashMap<String, CanalEntry.Column> afterColumnsMap = new HashMap<String, CanalEntry.Column>();
                rowData.getAfterColumnsList().stream().forEach(column -> afterColumnsMap.put(column.getName(), (CanalEntry.Column)column));
                OqsEngineEntity entity = null;
                switch (eventType) {
                    case INSERT: 
                    case UPDATE: {
                        entity = this.oneRowParser(afterColumnsMap, false, iEntityClass);
                        break;
                    }
                    case DELETE: {
                        entity = this.oneRowParser(beforeColumnsMap, true, iEntityClass);
                    }
                }
                this.paddingData(binlogRowDataMap, tableName, eventType, entity);
            }
        }
        catch (Exception e) {
            log.error("batch : {}, parse entry value failed, [{}], [{}]", new Object[]{parserContext.getBatchId(), entry.getStoreValue(), e});
            return;
        }
    }

    private void paddingData(Map<CanalEntry.EventType, Map<String, Map<Long, OqsEngineEntity>>> binlogRowDataMap, String tableName, CanalEntry.EventType eventType, OqsEngineEntity entity) {
        Map<Object, Object> eventTypeRowDatas = new HashMap();
        if (binlogRowDataMap.get(eventType) == null) {
            binlogRowDataMap.put(eventType, eventTypeRowDatas);
        } else {
            eventTypeRowDatas = binlogRowDataMap.get(eventType);
        }
        Map<Long, OqsEngineEntity> eventTypeTableRowDatas = new HashMap();
        if (eventTypeRowDatas.get(tableName) == null) {
            eventTypeRowDatas.put(tableName, eventTypeTableRowDatas);
        } else {
            eventTypeTableRowDatas = (Map)eventTypeRowDatas.get(tableName);
        }
        eventTypeTableRowDatas.put(entity.getId(), entity);
    }

    private OqsEngineEntity oneRowParser(Map<String, CanalEntry.Column> columns, boolean isDelete, IEntityClass tableEntityClass) throws SQLException, JsonProcessingException {
        long entityClass = BinLogParseUtils.getLongFromColumn(columns, "_sys_entityclass");
        String profile = BinLogParseUtils.getStringFromColumn(columns, "_sys_profile");
        long id = BinLogParseUtils.getLongFromColumn(columns, "id");
        IEntityClass iEntityClass = tableEntityClass;
        OqsEngineEntity.Builder builder = new OqsEngineEntity.Builder();
        builder.withDeleted(isDelete);
        builder.withEntityClassRef(new EntityClassRef(entityClass, "", "", profile));
        builder.withId(id);
        if (entityClass != tableEntityClass.id()) {
            builder.withFather(tableEntityClass.id());
        } else {
            IEntityClass ec = tableEntityClass.extendEntityClass();
            if (null != ec) {
                builder.withFather(ec.id());
            } else {
                builder.withFather(0L);
            }
        }
        builder.withAttribute("id", (Object)id);
        HashMap iEntityFieldMap = new HashMap();
        this.engine.describe(iEntityClass, profile).getAllFields().stream().forEach(p -> iEntityFieldMap.put(p.name().replace(".", "_"), p));
        for (CanalEntry.Column column : columns.values()) {
            if (column.getName().equals("_sys_operatetime")) {
                long updateTime = Long.parseLong(column.getValue());
                builder.withUpdateTime(updateTime);
                continue;
            }
            if (column.getName().equals("_sys_ver")) {
                if (column.getValue().isEmpty()) continue;
                int version = Integer.parseInt(column.getValue());
                builder.withVersion(version);
                continue;
            }
            if (column.getName().equals("id") || column.getName().equals("_sys_entityclass") || column.getName().equals("_sys_profile") || column.getName().equals("_sys_deleted")) continue;
            if (column.getName().equals("_sys_dynamic")) {
                builder.withAttributes(this.attrCollection(iEntityClass, columns));
                continue;
            }
            String name = column.getName();
            String value = column.getValue();
            IEntityField field = (IEntityField)iEntityFieldMap.get(name);
            if (null == field) {
                log.warn("entityField can not be null, column name {}", (Object)name);
                continue;
            }
            builder.withAttribute(name, (Object)value);
        }
        return builder.build();
    }

    private Map<String, Object> attrCollection(IEntityClass entityClass, Map<String, CanalEntry.Column> columns) throws JsonProcessingException {
        String attrStr = BinLogParseUtils.getStringFromColumn(columns, "_sys_dynamic");
        Map<String, Object> result = attrStr.isEmpty() ? new HashMap<String, Object>() : ParseMessageToRowData.attributesToMap(attrStr);
        entityClass.selfFields().stream().filter(IEntityField::isDynamic).forEach(f -> {
            if (!result.containsKey(f.name())) {
                result.put(f.name(), null);
            } else if (f.type().equals((Object)FieldType.BOOLEAN)) {
                result.computeIfPresent(f.name(), (k, s) -> (Integer)s != 0);
            }
        });
        return result;
    }

    public static Map<String, Object> attributesToMap(String attrStr) throws JsonProcessingException {
        return (Map)JacksonDefaultMapper.OBJECT_MAPPER.readValue(attrStr, Map.class);
    }

    private Optional<IEntityClass> foundEntityClassFromTableName(String tableName) {
        String[] tableSplit = tableName.split("_");
        if (tableSplit.length < 3) {
            return Optional.empty();
        }
        String code = tableSplit[2];
        String profile = null;
        if (tableSplit.length > 3) {
            profile = tableSplit[3];
        }
        return this.engine.loadByCode(code, profile);
    }
}

