package com.xforceplus.ultraman.cdc.core.remote;

import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.xforceplus.ultraman.cdc.CDCServer;
import com.xforceplus.ultraman.cdc.core.remote.connect.RemoteCDCConnector;
import com.xforceplus.ultraman.cdc.core.remote.runner.DefaultCDCConsumer;
import com.xforceplus.ultraman.cdc.dto.enums.CDCStatus;
import com.xforceplus.ultraman.cdc.processor.DataProcessor;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.cdc.reader.CanalPropertiesReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;


/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class DispatcherCDCServer implements CDCServer {

    private List<DefaultCDCConsumer> consumers = new ArrayList<>();

    private ScheduledExecutorService executor = null;

    private volatile boolean ready = false;

    public DispatcherCDCServer(CDCPropertyPackage cdcPropertyPackage, DataProcessor dataProcessor) {

        this.executor = Executors.newScheduledThreadPool(cdcPropertyPackage.readers().size(),
            new NamedThreadFactory("cdc-server-runner"));

        for (CanalPropertiesReader canalPropertiesReader : cdcPropertyPackage.readers()) {
            this.consumers.add(new DefaultCDCConsumer(new RemoteCDCConnector(canalPropertiesReader), dataProcessor, metrics));
        }
    }

    @Override
    public void init() {
        for (DefaultCDCConsumer consumer : consumers) {
            consumer.init();
        }
        ready = true;
    }

    @Override
    public void destroy() {
        for (DefaultCDCConsumer consumer : consumers) {
            consumer.destroy();
        }

        executor.shutdown();

        ready = false;
    }

    @Override
    public void execute() {
        for (DefaultCDCConsumer consumer : consumers) {
            executor.submit(consumer::execute);
        }
    }

    @Override
    public boolean allReady() {
        return ready;
    }

    @Override
    public Map<String, CDCStatus> metrics() {
        return metrics;
    }
}
